/*
 Highcharts Gantt JS v10.0.0 (2022-03-07)

 Gantt series

 (c) 2016-2021 Lars A. V. Cabrera

 License: www.highcharts.com/license
*/
(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/gantt",["highcharts"],function(J){c(J);c.Highcharts=J;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function J(c,t,v,u){c.hasOwnProperty(t)||(c[t]=u.apply(null,v),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:c[t]}})))}c=c?c._modules:{};J(c,"Series/XRange/XRangePoint.js",
[c["Core/Series/Point.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,t,v){var u=this&&this.__extends||function(){var c=function(m,k){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,d){k.__proto__=d}||function(k,d){for(var q in d)d.hasOwnProperty(q)&&(k[q]=d[q])};return c(m,k)};return function(m,k){function x(){this.constructor=m}c(m,k);m.prototype=null===k?Object.create(k):(x.prototype=k.prototype,new x)}}();v=v.extend;t=function(t){function m(){var k=
null!==t&&t.apply(this,arguments)||this;k.options=void 0;k.series=void 0;return k}u(m,t);m.getColorByCategory=function(k,m){var d=k.options.colors||k.chart.options.colors;k=m.y%(d?d.length:k.chart.options.chart.colorCount);return{colorIndex:k,color:d&&d[k]}};m.prototype.resolveColor=function(){var k=this.series;if(k.options.colorByPoint&&!this.options.color){var x=m.getColorByCategory(k,this);k.chart.styledMode||(this.color=x.color);this.options.colorIndex||(this.colorIndex=x.colorIndex)}else this.color||
(this.color=k.color)};m.prototype.init=function(){c.prototype.init.apply(this,arguments);this.y||(this.y=0);return this};m.prototype.setState=function(){c.prototype.setState.apply(this,arguments);this.series.drawPoint(this,this.series.getAnimationVerb())};m.prototype.getLabelConfig=function(){var k=c.prototype.getLabelConfig.call(this),m=this.series.yAxis.categories;k.x2=this.x2;k.yCategory=this.yCategory=m&&m[this.y];return k};m.prototype.isValid=function(){return"number"===typeof this.x&&"number"===
typeof this.x2};return m}(t.seriesTypes.column.prototype.pointClass);v(t.prototype,{ttBelow:!1,tooltipDateKeys:["x","x2"]});return t});J(c,"Series/XRange/XRangeComposition.js",[c["Core/Axis/Axis.js"],c["Core/Utilities.js"]],function(c,t){var v=t.addEvent,u=t.pick;v(c,"afterGetSeriesExtremes",function(){var c=this.series,m;if(this.isXAxis){var k=u(this.dataMax,-Number.MAX_VALUE);c.forEach(function(c){c.x2Data&&c.x2Data.forEach(function(d){d>k&&(k=d,m=!0)})});m&&(this.dataMax=k)}})});J(c,"Series/XRange/XRangeSeries.js",
[c["Core/Globals.js"],c["Core/Color/Color.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"],c["Series/XRange/XRangePoint.js"]],function(c,t,v,u,B){var m=this&&this.__extends||function(){var a=function(b,p){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,a){p.__proto__=a}||function(p,a){for(var b in a)a.hasOwnProperty(b)&&(p[b]=a[b])};return a(b,p)};return function(b,p){function C(){this.constructor=b}a(b,p);b.prototype=null===p?Object.create(p):(C.prototype=p.prototype,
new C)}}(),k=t.parse,x=v.series,d=v.seriesTypes.column,q=d.prototype,g=u.clamp,z=u.correctFloat,D=u.defined;t=u.extend;var H=u.find,e=u.isNumber,a=u.isObject,b=u.merge,l=u.pick;u=function(F){function G(){var a=null!==F&&F.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(G,F);G.prototype.init=function(){d.prototype.init.apply(this,arguments);this.options.stacking=void 0};G.prototype.getColumnMetrics=function(){function a(){b.series.forEach(function(a){var p=a.xAxis;
a.xAxis=a.yAxis;a.yAxis=p})}var b=this.chart;a();var l=q.getColumnMetrics.call(this);a();return l};G.prototype.cropData=function(a,b,l,e){b=x.prototype.cropData.call(this,this.x2Data,b,l,e);b.xData=a.slice(b.start,b.end);return b};G.prototype.findPointIndex=function(a){var p=this.cropped,b=this.cropStart,l=this.points,g=a.id;if(g)var d=(d=H(l,function(a){return a.id===g}))?d.index:void 0;"undefined"===typeof d&&(d=(d=H(l,function(p){return p.x===a.x&&p.x2===a.x2&&!p.touched}))?d.index:void 0);p&&
e(d)&&e(b)&&d>=b&&(d-=b);return d};G.prototype.translatePoint=function(p){var C=this.xAxis,d=this.yAxis,F=this.columnMetrics,E=this.options,k=E.minPointLength||0,q=(p.shapeArgs&&p.shapeArgs.width||0)/2,A=this.pointXOffset=F.offset,n=p.plotX,y=l(p.x2,p.x+(p.len||0)),r=C.translate(y,0,0,0,1);y=Math.abs(r-n);var f=this.chart.inverted,h=l(E.borderWidth,1)%2/2,w=F.offset,L=Math.round(F.width);k&&(k-=y,0>k&&(k=0),n-=k/2,r+=k/2);n=Math.max(n,-10);r=g(r,-10,C.len+10);D(p.options.pointWidth)&&(w-=(Math.ceil(p.options.pointWidth)-
L)/2,L=Math.ceil(p.options.pointWidth));E.pointPlacement&&e(p.plotY)&&d.categories&&(p.plotY=d.translate(p.y,0,1,0,1,E.pointPlacement));E=Math.floor(Math.min(n,r))+h;E={x:E,y:Math.floor(p.plotY+w)+h,width:Math.floor(Math.max(n,r))+h-E,height:L,r:this.options.borderRadius};p.shapeArgs=E;f?p.tooltipPos[1]+=A+q:p.tooltipPos[0]-=q+A-E.width/2;q=E.x;A=q+E.width;0>q||A>C.len?(q=g(q,0,C.len),A=g(A,0,C.len),r=A-q,p.dlBox=b(E,{x:q,width:A-q,centerX:r?r/2:null})):p.dlBox=null;q=p.tooltipPos;A=f?1:0;r=f?0:1;
F=this.columnMetrics?this.columnMetrics.offset:-F.width/2;q[A]=f?q[A]+E.width/2:q[A]+(C.reversed?-1:0)*E.width;q[r]=g(q[r]+(f?-1:1)*F,0,d.len-1);if(d=p.partialFill)a(d)&&(d=d.amount),e(d)||(d=0),p.partShapeArgs=b(E,{r:this.options.borderRadius}),n=Math.max(Math.round(y*d+p.plotX-n),0),p.clipRectArgs={x:C.reversed?E.x+y-n:E.x,y:E.y,width:n,height:E.height}};G.prototype.translate=function(){q.translate.apply(this,arguments);this.points.forEach(function(a){this.translatePoint(a)},this)};G.prototype.drawPoint=
function(p,C){var e=this.options,d=this.chart.renderer,g=p.graphic,q=p.shapeType,F=p.shapeArgs,A=p.partShapeArgs,n=p.clipRectArgs,y=p.partialFill,r=e.stacking&&!e.borderRadius,f=p.state,h=e.states[f||"normal"]||{},w="undefined"===typeof f?"attr":C;f=this.pointAttribs(p,f);h=l(this.chart.options.chart.animation,h.animation);if(p.isNull||!1===p.visible)g&&(p.graphic=g.destroy());else{if(g)g.rect[C](F);else p.graphic=g=d.g("point").addClass(p.getClassName()).add(p.group||this.group),g.rect=d[q](b(F)).addClass(p.getClassName()).addClass("highcharts-partfill-original").add(g);
A&&(g.partRect?(g.partRect[C](b(A)),g.partialClipRect[C](b(n))):(g.partialClipRect=d.clipRect(n.x,n.y,n.width,n.height),g.partRect=d[q](A).addClass("highcharts-partfill-overlay").add(g).clip(g.partialClipRect)));this.chart.styledMode||(g.rect[C](f,h).shadow(e.shadow,null,r),A&&(a(y)||(y={}),a(e.partialFill)&&(y=b(e.partialFill,y)),p=y.fill||k(f.fill).brighten(-.3).get()||k(p.color||this.color).brighten(-.3).get(),f.fill=p,g.partRect[w](f,h).shadow(e.shadow,null,r)))}};G.prototype.drawPoints=function(){var a=
this,b=a.getAnimationVerb();a.points.forEach(function(p){a.drawPoint(p,b)})};G.prototype.getAnimationVerb=function(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"};G.prototype.isPointInside=function(a){var b=a.shapeArgs,p=a.plotX,e=a.plotY;return b?"undefined"!==typeof p&&"undefined"!==typeof e&&0<=e&&e<=this.yAxis.len&&0<=(b.x||0)+(b.width||0)&&p<=this.xAxis.len:F.prototype.isPointInside.apply(this,arguments)};G.defaultOptions=b(d.defaultOptions,{colorByPoint:!0,
dataLabels:{formatter:function(){var b=this.point.partialFill;a(b)&&(b=b.amount);if(e(b)&&0<b)return z(100*b)+"%"},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:'<span style="font-size: 10px">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">\u25cf</span> {series.name}: <b>{point.yCategory}</b><br/>'},borderRadius:3,pointRange:0});return G}(d);t(u.prototype,{type:"xrange",parallelArrays:["x","x2","y"],requireSorting:!1,animate:x.prototype.animate,cropShoulder:1,
getExtremesFromAll:!0,autoIncrement:c.noop,buildKDTree:c.noop,pointClass:B});v.registerSeriesType("xrange",u);"";return u});J(c,"Series/Gantt/GanttPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,t){var v=this&&this.__extends||function(){var c=function(m,k){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,d){k.__proto__=d}||function(k,d){for(var q in d)d.hasOwnProperty(q)&&(k[q]=d[q])};return c(m,k)};return function(m,k){function x(){this.constructor=
m}c(m,k);m.prototype=null===k?Object.create(k):(x.prototype=k.prototype,new x)}}(),u=t.pick;return function(c){function m(){var k=null!==c&&c.apply(this,arguments)||this;k.options=void 0;k.series=void 0;return k}v(m,c);m.setGanttPointAliases=function(k){function c(d,q){"undefined"!==typeof q&&(k[d]=q)}c("x",u(k.start,k.x));c("x2",u(k.end,k.x2));c("partialFill",u(k.completed,k.partialFill))};m.prototype.applyOptions=function(k,x){k=c.prototype.applyOptions.call(this,k,x);m.setGanttPointAliases(k);
return k};m.prototype.isValid=function(){return("number"===typeof this.start||"number"===typeof this.x)&&("number"===typeof this.end||"number"===typeof this.x2||this.milestone)};return m}(c.seriesTypes.xrange.prototype.pointClass)});J(c,"Core/Axis/BrokenAxis.js",[c["Extensions/Stacking.js"],c["Core/Utilities.js"]],function(c,t){var v=t.addEvent,u=t.find,B=t.fireEvent,m=t.isArray,k=t.isNumber,x=t.pick,d;(function(d){function g(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,
!1)}function q(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function D(){var a=this.brokenAxis;if(a&&a.hasBreaks){for(var b=this.tickPositions,e=this.tickPositions.info,l=[],g=0;g<b.length;g++)a.isInAnyBreak(b[g])||l.push(b[g]);this.tickPositions=l;this.tickPositions.info=e}}function H(){this.brokenAxis||(this.brokenAxis=new G(this))}function e(){var a=this.options.connectNulls,b=this.points,e=this.xAxis,g=this.yAxis;if(this.isDirty)for(var l=b.length;l--;){var d=b[l],q=
!(null===d.y&&!1===a)&&(e&&e.brokenAxis&&e.brokenAxis.isInAnyBreak(d.x,!0)||g&&g.brokenAxis&&g.brokenAxis.isInAnyBreak(d.y,!0));d.visible=q?!1:!1!==d.options.visible}}function a(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,x(this.pointArrayMap,["y"]))}function b(a,b){var p=this,e=p.points,g,l,d,A;if(a&&a.brokenAxis&&a.brokenAxis.hasBreaks){var n=a.brokenAxis;b.forEach(function(b){g=n&&n.breakArray||[];l=a.isXAxis?a.min:x(p.options.threshold,a.min);e.forEach(function(n){A=x(n["stack"+
b.toUpperCase()],n[b]);g.forEach(function(f){if(k(l)&&k(A)){d=!1;if(l<f.from&&A>f.to||l>f.from&&A<f.from)d="pointBreak";else if(l<f.from&&A>f.from&&A<f.to||l>f.from&&A>f.to&&A<f.from)d="pointInBreak";d&&B(a,d,{point:n,brk:f})}})})})}}function l(){var a=this.currentDataGrouping,b=a&&a.gapSize;a=this.points.slice();var e=this.yAxis,l=this.options.gapSize,g=a.length-1,d;if(l&&0<g)for("value"!==this.options.gapUnit&&(l*=this.basePointRange),b&&b>l&&b>=this.basePointRange&&(l=b),d=void 0;g--;)d&&!1!==
d.visible||(d=a[g+1]),b=a[g],!1!==d.visible&&!1!==b.visible&&(d.x-b.x>l&&(d=(b.x+d.x)/2,a.splice(g+1,0,{isNull:!0,x:d}),e.stacking&&this.options.stacking&&(d=e.stacking.stacks[this.stackKey][d]=new c(e,e.options.stackLabels,!1,d,this.stack),d.total=0)),d=b);return this.getGraphPath(a)}var F=[];d.compose=function(p,d){-1===F.indexOf(p)&&(F.push(p),p.keepProps.push("brokenAxis"),v(p,"init",H),v(p,"afterInit",g),v(p,"afterSetTickPositions",D),v(p,"afterSetOptions",q));if(-1===F.indexOf(d)){F.push(d);
var C=d.prototype;C.drawBreaks=b;C.gappedPath=l;v(d,"afterGeneratePoints",e);v(d,"afterRender",a)}return p};var G=function(){function a(a){this.hasBreaks=!1;this.axis=a}a.isInBreak=function(a,b){var d=a.repeat||Infinity,e=a.from,l=a.to-a.from;b=b>=e?(b-e)%d:d-(e-b)%d;return a.inclusive?b<=l:b<l&&0!==b};a.lin2Val=function(b){var d=this.brokenAxis;d=d&&d.breakArray;if(!d||!k(b))return b;var e;for(e=0;e<d.length;e++){var l=d[e];if(l.from>=b)break;else l.to<b?b+=l.len:a.isInBreak(l,b)&&(b+=l.len)}return b};
a.val2Lin=function(b){var d=this.brokenAxis;d=d&&d.breakArray;if(!d||!k(b))return b;var e=b,l;for(l=0;l<d.length;l++){var g=d[l];if(g.to<=b)e-=g.len;else if(g.from>=b)break;else if(a.isInBreak(g,b)){e-=b-g.from;break}}return e};a.prototype.findBreakAt=function(a,b){return u(b,function(b){return b.from<a&&a<b.to})};a.prototype.isInAnyBreak=function(b,d){var l=this.axis,e=l.options.breaks||[],g=e.length,p;if(g&&k(b)){for(;g--;)if(a.isInBreak(e[g],b)){var A=!0;p||(p=x(e[g].showPoints,!l.isXAxis))}var n=
A&&d?A&&!p:A}return n};a.prototype.setBreaks=function(b,d){var e=this,l=e.axis,g=m(b)&&!!b.length;l.isDirty=e.hasBreaks!==g;e.hasBreaks=g;l.options.breaks=l.userOptions.breaks=b;l.forceRedraw=!0;l.series.forEach(function(a){a.isDirty=!0});g||l.val2lin!==a.val2Lin||(delete l.val2lin,delete l.lin2val);g&&(l.userOptions.ordinal=!1,l.lin2val=a.lin2Val,l.val2lin=a.val2Lin,l.setExtremes=function(a,b,n,y,r){if(e.hasBreaks){for(var f=this.options.breaks||[],h;h=e.findBreakAt(a,f);)a=h.to;for(;h=e.findBreakAt(b,
f);)b=h.from;b<a&&(b=a)}l.constructor.prototype.setExtremes.call(this,a,b,n,y,r)},l.setAxisTranslation=function(){l.constructor.prototype.setAxisTranslation.call(this);e.unitLength=void 0;if(e.hasBreaks){var b=l.options.breaks||[],d=[],n=[],y=x(l.pointRangePadding,0),r=0,f,h=l.userMin||l.min,w=l.userMax||l.max,g;b.forEach(function(b){f=b.repeat||Infinity;k(h)&&k(w)&&(a.isInBreak(b,h)&&(h+=b.to%f-h%f),a.isInBreak(b,w)&&(w-=w%f-b.from%f))});b.forEach(function(a){O=a.from;f=a.repeat||Infinity;if(k(h)&&
k(w)){for(;O-f>h;)O-=f;for(;O<h;)O+=f;for(g=O;g<w;g+=f)d.push({value:g,move:"in"}),d.push({value:g+a.to-a.from,move:"out",size:a.breakSize})}});d.sort(function(f,h){return f.value===h.value?("in"===f.move?0:1)-("in"===h.move?0:1):f.value-h.value});var N=0;var O=h;d.forEach(function(f){N+="in"===f.move?1:-1;1===N&&"in"===f.move&&(O=f.value);0===N&&k(O)&&(n.push({from:O,to:f.value,len:f.value-O-(f.size||0)}),r+=f.value-O-(f.size||0))});e.breakArray=n;k(h)&&k(w)&&k(l.min)&&(e.unitLength=w-h-r+y,B(l,
"afterBreaks"),l.staticScale?l.transA=l.staticScale:e.unitLength&&(l.transA*=(w-l.min+y)/e.unitLength),y&&(l.minPixelPadding=l.transA*(l.minPointOffset||0)),l.min=h,l.max=w)}});x(d,!0)&&l.chart.redraw()};return a}();d.Additions=G})(d||(d={}));return d});J(c,"Core/Axis/GridAxis.js",[c["Core/Axis/Axis.js"],c["Core/Axis/AxisDefaults.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,t,v,u){var B=v.dateFormats,m=u.addEvent,k=u.defined,x=u.erase,d=u.find,q=u.isArray,g=u.isNumber,z=u.merge,D=
u.pick,H=u.timeUnits,e=u.wrap,a;(function(a){function b(f,h){var a={width:0,height:0};h.forEach(function(h){h=f[h];if(u.isObject(h,!0)){var b=u.isObject(h.label,!0)?h.label:{};h=b.getBBox?b.getBBox().height:0;b.textStr&&!g(b.textPxLength)&&(b.textPxLength=b.getBBox().width);var n=g(b.textPxLength)?Math.round(b.textPxLength):0;b.textStr&&(n=Math.round(b.getBBox().width));a.height=Math.max(h,a.height);a.width=Math.max(n,a.width)}});"treegrid"===this.options.type&&this.treeGrid&&this.treeGrid.mapOfPosToGridNode&&
(a.width+=this.options.labels.indentation*((this.treeGrid.mapOfPosToGridNode[-1].height||0)-1));return a}function F(){var f=this.grid;(f&&f.columns||[]).forEach(function(f){f.getOffset()})}function G(f){if(!0===(this.options.grid||{}).enabled){var h=this.axisTitle,b=this.height,n=this.horiz,r=this.left,l=this.offset,N=this.opposite,w=this.options,y=this.top,d=this.width,e=this.tickSize(),g=h&&h.getBBox().width,p=w.title.x,A=w.title.y,L=D(w.title.margin,n?5:10);h=this.chart.renderer.fontMetrics(w.title.style.fontSize,
h).f;e=(n?y+b:r)+(n?1:-1)*(N?-1:1)*(e?e[0]/2:0)+(this.side===a.Side.bottom?h:0);f.titlePosition.x=n?r-(g||0)/2-L+p:e+(N?d:0)+l+p;f.titlePosition.y=n?e-(N?b:0)+(N?h:-h)/2+l+A:y-L+A}}function p(){var f=this.chart,h=this.options.grid;h=void 0===h?{}:h;var a=this.userOptions;if(h.enabled){var b=this.options;b.labels.align=D(b.labels.align,"center");this.categories||(b.showLastLabel=!1);this.labelRotation=0;b.labels.rotation=0}if(h.columns){b=this.grid.columns=[];for(var n=this.grid.columnIndex=0;++n<
h.columns.length;){var r=z(a,h.columns[h.columns.length-n-1],{linkedTo:0,type:"category",scrollbar:{enabled:!1}});delete r.grid.columns;r=new c(this.chart,r);r.grid.isColumn=!0;r.grid.columnIndex=n;x(f.axes,r);x(f[this.coll],r);b.push(r)}}}function C(){var f=this.grid,h=this.options;if(!0===(h.grid||{}).enabled){var b=this.min||0,n=this.max||0;this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions);this.rightWall&&this.rightWall.destroy();if(this.grid&&this.grid.isOuterAxis()&&
this.axisLine){var r=h.lineWidth;if(r){r=this.getLinePath(r);var l=r[0],w=r[1],y=((this.tickSize("tick")||[1])[0]-1)*(this.side===a.Side.top||this.side===a.Side.left?-1:1);"M"===l[0]&&"L"===w[0]&&(this.horiz?(l[2]+=y,w[2]+=y):(l[1]+=y,w[1]+=y));!this.horiz&&this.chart.marginRight&&(l=[l,["L",this.left,l[2]||0]],y=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(n+this.tickmarkOffset)],w=[["M",w[1]||0,this.toPixels(n+this.tickmarkOffset)],y],this.grid.upperBorder||0===b%1||(this.grid.upperBorder=
this.grid.renderBorder(l)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:h.lineColor,"stroke-width":h.lineWidth}),this.grid.upperBorder.animate({d:l})),this.grid.lowerBorder||0===n%1||(this.grid.lowerBorder=this.grid.renderBorder(w)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:h.lineColor,"stroke-width":h.lineWidth}),this.grid.lowerBorder.animate({d:w})));this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:h.lineColor,"stroke-width":h.lineWidth}),this.grid.axisLineExtra.animate({d:r})):
this.grid.axisLineExtra=this.grid.renderBorder(r);this.axisLine[this.showAxis?"show":"hide"](!0)}}(f&&f.columns||[]).forEach(function(f){f.render()});if(!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)){f=this.tickmarkOffset;h=this.tickPositions[this.tickPositions.length-1];r=this.tickPositions[0];for(l=w=void 0;(w=this.hiddenLabels.pop())&&w.element;)w.show();for(;(l=this.hiddenMarks.pop())&&l.element;)l.show();(w=this.ticks[r].label)&&(b-r>f?
this.hiddenLabels.push(w.hide()):w.show());(w=this.ticks[h].label)&&(h-n>f?this.hiddenLabels.push(w.hide()):w.show());(b=this.ticks[h].mark)&&h-n<f&&0<h-n&&this.ticks[h].isLast&&this.hiddenMarks.push(b.hide())}}}function Q(){var f=this.tickPositions&&this.tickPositions.info,h=this.options,a=this.userOptions.labels||{};(h.grid||{}).enabled&&(this.horiz?(this.series.forEach(function(f){f.options.pointRange=0}),f&&h.dateTimeLabelFormats&&h.labels&&!k(a.align)&&(!1===h.dateTimeLabelFormats[f.unitName].range||
1<f.count)&&(h.labels.align="left",k(a.x)||(h.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=this.tickInterval))}function M(f){var h=this.options;f=f.userOptions;var a=h&&u.isObject(h.grid,!0)?h.grid:{};if(!0===a.enabled){var b=z(!0,{className:"highcharts-grid-axis "+(f.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},
labels:{padding:2,style:{fontSize:"13px"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0},units:[["millisecond",[1,10,100]],["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},f);"xAxis"===this.coll&&(k(f.linkedTo)&&!k(f.tickPixelInterval)&&(b.tickPixelInterval=350),k(f.tickPixelInterval)||!k(f.linkedTo)||k(f.tickPositioner)||k(f.tickInterval)||(b.tickPositioner=function(f,h){var a=this.linkedParent&&this.linkedParent.tickPositions&&this.linkedParent.tickPositions.info;
if(a){for(var n=b.units||[],r=void 0,w=void 0,l=void 0,y=0;y<n.length;y++)if(n[y][0]===a.unitName){r=y;break}n[r+1]?(l=n[r+1][0],w=(n[r+1][1]||[1])[0]):"year"===a.unitName&&(l="year",w=10*a.count);a=H[l];this.tickInterval=a*w;return this.getTimeTicks({unitRange:a,count:w,unitName:l},f,h,this.options.startOfWeek)}}));z(!0,this.options,b);this.horiz&&(h.minPadding=D(f.minPadding,0),h.maxPadding=D(f.maxPadding,0));g(h.grid.borderWidth)&&(h.tickWidth=h.lineWidth=a.borderWidth)}}function E(f){f=(f=f.userOptions)&&
f.grid||{};var h=f.columns;f.enabled&&h&&z(!0,this.options,h[h.length-1])}function K(){(this.grid.columns||[]).forEach(function(f){f.setScale()})}function I(f){var h=t.defaultLeftAxisOptions,a=this.horiz,b=this.maxLabelDimensions,n=this.options.grid;n=void 0===n?{}:n;n.enabled&&b&&(h=2*Math.abs(h.labels.x),a=a?n.cellHeight||h+b.height:h+b.width,q(f.tickSize)?f.tickSize[0]=a:f.tickSize=[a,0])}function A(){this.axes.forEach(function(f){(f.grid&&f.grid.columns||[]).forEach(function(f){f.setAxisSize();
f.setAxisTranslation()})})}function n(f){var h=this.grid;(h.columns||[]).forEach(function(h){h.destroy(f.keepEvents)});h.columns=void 0}function y(f){f=f.userOptions||{};var h=f.grid||{};h.enabled&&k(h.borderColor)&&(f.tickColor=f.lineColor=h.borderColor);this.grid||(this.grid=new L(this));this.hiddenLabels=[];this.hiddenMarks=[]}function r(f){var h=this.label,b=this.axis,n=b.reversed,r=b.chart,w=b.options.grid||{},l=b.options.labels,y=l.align,e=a.Side[b.side],d=f.tickmarkOffset,p=b.tickPositions,
N=this.pos-d;p=g(p[f.index+1])?p[f.index+1]-d:(b.max||0)+d;var A=b.tickSize("tick");d=A?A[0]:0;A=A?A[1]/2:0;if(!0===w.enabled){if("top"===e){w=b.top+b.offset;var L=w-d}else"bottom"===e?(L=r.chartHeight-b.bottom+b.offset,w=L+d):(w=b.top+b.len-(b.translate(n?p:N)||0),L=b.top+b.len-(b.translate(n?N:p)||0));"right"===e?(e=r.chartWidth-b.right+b.offset,n=e+d):"left"===e?(n=b.left+b.offset,e=n-d):(e=Math.round(b.left+(b.translate(n?p:N)||0))-A,n=Math.min(Math.round(b.left+(b.translate(n?N:p)||0))-A,b.left+
b.len));this.slotWidth=n-e;f.pos.x="left"===y?e:"right"===y?n:e+(n-e)/2;f.pos.y=L+(w-L)/2;r=r.renderer.fontMetrics(l.style.fontSize,h&&h.element);h=h?h.getBBox().height:0;l.useHTML?f.pos.y+=r.b+-(h/2):(h=Math.round(h/r.h),f.pos.y+=(r.b-(r.h-r.f))/2+-((h-1)*r.h/2));f.pos.x+=b.horiz&&l.x||0}}function f(f){var h=f.axis,a=f.value;if(h.options.grid&&h.options.grid.enabled){var b=h.tickPositions,n=(h.linkedParent||h).series[0],r=a===b[0];b=a===b[b.length-1];var w=n&&d(n.options.data,function(f){return f[h.isXAxis?
"x":"y"]===a}),l=void 0;w&&n.is("gantt")&&(l=z(w),v.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(l));f.isFirst=r;f.isLast=b;f.point=l}}function h(){var f=this.options,h=this.categories,a=this.tickPositions,b=a[0],n=a[a.length-1],r=this.linkedParent&&this.linkedParent.min||this.min,w=this.linkedParent&&this.linkedParent.max||this.max,l=this.tickInterval;!0!==(f.grid||{}).enabled||h||!this.horiz&&!this.isLinked||(b<r&&b+l>r&&!f.startOnTick&&(a[0]=r),n>w&&n-l<w&&!f.endOnTick&&(a[a.length-
1]=w))}function w(f){var h=this.options.grid;return!0===(void 0===h?{}:h).enabled&&this.categories?this.tickInterval:f.apply(this,Array.prototype.slice.call(arguments,1))}(function(f){f[f.top=0]="top";f[f.right=1]="right";f[f.bottom=2]="bottom";f[f.left=3]="left"})(a.Side||(a.Side={}));a.compose=function(a,l,d){-1===a.keepProps.indexOf("grid")&&(a.keepProps.push("grid"),a.prototype.getMaxLabelDimensions=b,e(a.prototype,"unsquish",w),m(a,"init",y),m(a,"afterGetOffset",F),m(a,"afterGetTitlePosition",
G),m(a,"afterInit",p),m(a,"afterRender",C),m(a,"afterSetAxisTranslation",Q),m(a,"afterSetOptions",M),m(a,"afterSetOptions",E),m(a,"afterSetScale",K),m(a,"afterTickSize",I),m(a,"trimTicks",h),m(a,"destroy",n));m(l,"afterSetChartSize",A);m(d,"afterGetLabelPosition",r);m(d,"labelFormat",f);return a};var L=function(){function f(f){this.axis=f}f.prototype.isOuterAxis=function(){var f=this.axis,h=f.grid.columnIndex,a=f.linkedParent&&f.linkedParent.grid.columns||f.grid.columns,b=h?f.linkedParent:f,n=-1,
r=0;f.chart[f.coll].forEach(function(h,a){h.side!==f.side||h.options.isInternal||(r=a,h===b&&(n=a))});return r===n&&(g(h)?a.length===h:!0)};f.prototype.renderBorder=function(f){var h=this.axis,a=h.chart.renderer,b=h.options;f=a.path(f).addClass("highcharts-axis-line").add(h.axisBorder);a.styledMode||f.attr({stroke:b.lineColor,"stroke-width":b.lineWidth,zIndex:7});return f};return f}();a.Additions=L})(a||(a={}));B.E=function(a){return this.dateFormat("%a",a,!0).charAt(0)};B.W=function(a){a=new this.Date(a);
var b=(this.get("Day",a)+6)%7,e=new this.Date(a.valueOf());this.set("Date",e,this.get("Date",a)-b+3);b=new this.Date(this.get("FullYear",e),0,1);4!==this.get("Day",b)&&(this.set("Month",a,0),this.set("Date",a,1+(11-this.get("Day",b))%7));return(1+Math.floor((e.valueOf()-b.valueOf())/6048E5)).toString()};"";return a});J(c,"Gantt/Tree.js",[c["Core/Utilities.js"]],function(c){var t=c.extend,v=c.isNumber,u=c.pick,B=function(k,c){var d=k.reduce(function(d,g){var q=u(g.parent,"");"undefined"===typeof d[q]&&
(d[q]=[]);d[q].push(g);return d},{});Object.keys(d).forEach(function(q,g){var k=d[q];""!==q&&-1===c.indexOf(q)&&(k.forEach(function(d){g[""].push(d)}),delete g[q])});return d},m=function(k,c,d,q,g,z){var D=0,H=0,e=z&&z.after,a=z&&z.before;c={data:q,depth:d-1,id:k,level:d,parent:c};var b,l;"function"===typeof a&&a(c,z);a=(g[k]||[]).map(function(a){var e=m(a.id,k,d+1,a,g,z),p=a.start;a=!0===a.milestone?p:a.end;b=!v(b)||p<b?p:b;l=!v(l)||a>l?a:l;D=D+1+e.descendants;H=Math.max(e.height+1,H);return e});
q&&(q.start=u(q.start,b),q.end=u(q.end,l));t(c,{children:a,descendants:D,height:H});"function"===typeof e&&e(c,z);return c};return{getListOfParents:B,getNode:m,getTree:function(c,x){var d=c.map(function(d){return d.id});c=B(c,d);return m("",null,1,null,c,x)}}});J(c,"Core/Axis/TreeGridTick.js",[c["Core/Utilities.js"]],function(c){var t=c.addEvent,v=c.isObject,u=c.isNumber,B=c.pick,m=c.wrap,k;(function(c){function d(){this.treeGrid||(this.treeGrid=new H(this))}function q(e,a){e=e.treeGrid;var b=!e.labelIcon,
l=a.renderer,d=a.xy,g=a.options,p=g.width||0,c=g.height||0,q=d.x-p/2-(g.padding||0);d=d.y-c/2;var k=a.collapsed?90:180,m=a.show&&u(d),z=e.labelIcon;z||(e.labelIcon=z=l.path(l.symbols[g.type](g.x||0,g.y||0,p,c)).addClass("highcharts-label-icon").add(a.group));z.attr({y:m?0:-9999});l.styledMode||z.attr({cursor:"pointer",fill:B(a.color,"#666666"),"stroke-width":1,stroke:g.lineColor,strokeWidth:g.lineWidth||0});z[b?"attr":"animate"]({translateX:q,translateY:d,rotation:k})}function g(d,a,b,l,g,c,p,q,k){var e=
B(this.options&&this.options.labels,c);c=this.pos;var C=this.axis,F="treegrid"===C.options.type;d=d.apply(this,[a,b,l,g,e,p,q,k]);F&&(a=e&&v(e.symbol,!0)?e.symbol:{},e=e&&u(e.indentation)?e.indentation:0,c=(c=(C=C.treeGrid.mapOfPosToGridNode)&&C[c])&&c.depth||1,d.x+=(a.width||0)+2*(a.padding||0)+(c-1)*e);return d}function k(d){var a=this,b=a.pos,l=a.axis,e=a.label,g=l.treeGrid.mapOfPosToGridNode,p=l.options,c=B(a.options&&a.options.labels,p&&p.labels),k=c&&v(c.symbol,!0)?c.symbol:{},z=(g=g&&g[b])&&
g.depth;p="treegrid"===p.type;var m=-1<l.tickPositions.indexOf(b);b=l.chart.styledMode;p&&g&&e&&e.element&&e.addClass("highcharts-treegrid-node-level-"+z);d.apply(a,Array.prototype.slice.call(arguments,1));p&&e&&e.element&&g&&g.descendants&&0<g.descendants&&(l=l.treeGrid.isCollapsed(g),q(a,{color:!b&&e.styles&&e.styles.color||"",collapsed:l,group:e.parentGroup,options:k,renderer:e.renderer,show:m,xy:e.xy}),k="highcharts-treegrid-node-"+(l?"expanded":"collapsed"),e.addClass("highcharts-treegrid-node-"+
(l?"collapsed":"expanded")).removeClass(k),b||e.css({cursor:"pointer"}),[e,a.treeGrid.labelIcon].forEach(function(b){b&&!b.attachedTreeGridEvents&&(t(b.element,"mouseover",function(){e.addClass("highcharts-treegrid-node-active");e.renderer.styledMode||e.css({textDecoration:"underline"})}),t(b.element,"mouseout",function(){var a=v(c.style)?c.style:{};e.removeClass("highcharts-treegrid-node-active");e.renderer.styledMode||e.css({textDecoration:a.textDecoration})}),t(b.element,"click",function(){a.treeGrid.toggleCollapse()}),
b.attachedTreeGridEvents=!0)}))}var D=!1;c.compose=function(e){D||(t(e,"init",d),m(e.prototype,"getLabelPosition",g),m(e.prototype,"renderLabel",k),e.prototype.collapse=function(a){this.treeGrid.collapse(a)},e.prototype.expand=function(a){this.treeGrid.expand(a)},e.prototype.toggleCollapse=function(a){this.treeGrid.toggleCollapse(a)},D=!0)};var H=function(){function e(a){this.tick=a}e.prototype.collapse=function(a){var b=this.tick,l=b.axis,e=l.brokenAxis;e&&l.treeGrid.mapOfPosToGridNode&&(b=l.treeGrid.collapse(l.treeGrid.mapOfPosToGridNode[b.pos]),
e.setBreaks(b,B(a,!0)))};e.prototype.destroy=function(){this.labelIcon&&this.labelIcon.destroy()};e.prototype.expand=function(a){var b=this.tick,e=b.axis,d=e.brokenAxis;d&&e.treeGrid.mapOfPosToGridNode&&(b=e.treeGrid.expand(e.treeGrid.mapOfPosToGridNode[b.pos]),d.setBreaks(b,B(a,!0)))};e.prototype.toggleCollapse=function(a){var b=this.tick,e=b.axis,d=e.brokenAxis;d&&e.treeGrid.mapOfPosToGridNode&&(b=e.treeGrid.toggleCollapse(e.treeGrid.mapOfPosToGridNode[b.pos]),d.setBreaks(b,B(a,!0)))};return e}();
c.Additions=H})(k||(k={}));return k});J(c,"Series/TreeUtilities.js",[c["Core/Color/Color.js"],c["Core/Utilities.js"]],function(c,t){function v(c,g){var k=g.before,q=g.idRoot,m=g.mapIdToNode[q],e=g.points[c.i],a=e&&e.options||{},b=[],l=0;c.levelDynamic=c.level-(!1!==g.levelIsConstant?0:m.level);c.name=d(e&&e.name,"");c.visible=q===c.id||!0===g.visible;"function"===typeof k&&(c=k(c,g));c.children.forEach(function(a,e){var d=u({},g);u(d,{index:e,siblings:c.children.length,visible:c.visible});a=v(a,d);
b.push(a);a.visible&&(l+=a.val)});k=d(a.value,l);c.visible=0<=k&&(0<l||c.visible);c.children=b;c.childrenTotal=l;c.isLeaf=c.visible&&!l;c.val=k;return c}var u=t.extend,B=t.isArray,m=t.isNumber,k=t.isObject,x=t.merge,d=t.pick;return{getColor:function(k,g){var m=g.index,q=g.mapOptionsToLevel,H=g.parentColor,e=g.parentColorIndex,a=g.series,b=g.colors,l=g.siblings,F=a.points,G=a.chart.options.chart,p;if(k){F=F[k.i];k=q[k.level]||{};if(q=F&&k.colorByPoint){var C=F.index%(b?b.length:G.colorCount);var x=
b&&b[C]}if(!a.chart.styledMode){b=F&&F.options.color;G=k&&k.color;if(p=H)p=(p=k&&k.colorVariation)&&"brightness"===p.key&&m&&l?c.parse(H).brighten(m/l*p.to).get():H;p=d(b,G,x,p,a.color)}var t=d(F&&F.options.colorIndex,k&&k.colorIndex,C,e,g.colorIndex)}return{color:p,colorIndex:t}},getLevelOptions:function(c){var g=null;if(k(c)){g={};var z=m(c.from)?c.from:1;var q=c.levels;var H={};var e=k(c.defaults)?c.defaults:{};B(q)&&(H=q.reduce(function(a,b){if(k(b)&&m(b.level)){var l=x({},b);var g=d(l.levelIsConstant,
e.levelIsConstant);delete l.levelIsConstant;delete l.level;b=b.level+(g?0:z-1);k(a[b])?x(!0,a[b],l):a[b]=l}return a},{}));q=m(c.to)?c.to:1;for(c=0;c<=q;c++)g[c]=x({},e,k(H[c])?H[c]:{})}return g},setTreeValues:v,updateRootId:function(c){if(k(c)){var g=k(c.options)?c.options:{};g=d(c.rootNode,g.rootId,"");k(c.userOptions)&&(c.userOptions.rootId=g);c.rootNode=g}return g}}});J(c,"Core/Axis/TreeGridAxis.js",[c["Core/Axis/BrokenAxis.js"],c["Core/Axis/GridAxis.js"],c["Gantt/Tree.js"],c["Core/Axis/TreeGridTick.js"],
c["Series/TreeUtilities.js"],c["Core/Utilities.js"]],function(c,t,v,u,B,m){var k=B.getLevelOptions,x=m.addEvent,d=m.find,q=m.fireEvent,g=m.isArray,z=m.isObject,D=m.isString,H=m.merge,e=m.pick,a=m.wrap,b;(function(b){function l(a,b){var n=a.collapseEnd||0;a=a.collapseStart||0;n>=b&&(a-=.5);return{from:a,to:n,showPoints:!1}}function m(a,b,n){var e=[],r=[],f={},h="boolean"===typeof b?b:!1,w={},l=-1;a=v.getTree(a,{after:function(f){f=w[f.pos];var h=0,a=0;f.children.forEach(function(f){a+=(f.descendants||
0)+1;h=Math.max((f.height||0)+1,h)});f.descendants=a;f.height=h;f.collapsed&&r.push(f)},before:function(a){var b=z(a.data,!0)?a.data:{},n=D(b.name)?b.name:"",r=f[a.parent];r=z(r,!0)?w[r.pos]:null;var y=function(f){return f.name===n},g;h&&z(r,!0)&&(g=d(r.children,y))?(y=g.pos,g.nodes.push(a)):y=l++;w[y]||(w[y]=g={depth:r?r.depth+1:0,name:n,id:b.id,nodes:[a],children:[],pos:y},-1!==y&&e.push(n),z(r,!0)&&r.children.push(g));D(a.id)&&(f[a.id]=a);g&&!0===b.collapsed&&(g.collapsed=!0);a.pos=y}});w=function(f,
h){var a=function(f,b,n){var r=b+(-1===b?0:h-1),e=(r-b)/2,w=b+e;f.nodes.forEach(function(f){var h=f.data;z(h,!0)&&(h.y=b+(h.seriesIndex||0),delete h.seriesIndex);f.pos=w});n[w]=f;f.pos=w;f.tickmarkOffset=e+.5;f.collapseStart=r+.5;f.children.forEach(function(f){a(f,r+1,n);r=(f.collapseEnd||0)-.5});f.collapseEnd=r+.5;return n};return a(f["-1"],-1,{})}(w,n);return{categories:e,mapOfIdToNode:f,mapOfPosToGridNode:w,collapsedNodes:r,tree:a}}function p(a){a.target.axes.filter(function(a){return"treegrid"===
a.options.type}).forEach(function(b){var n=b.options||{},e=n.labels,r=n.uniqueNames;n=n.max;var f=0;if(!b.treeGrid.mapOfPosToGridNode||b.series.some(function(f){return!f.hasRendered||f.isDirtyData||f.isDirty})){var h=b.series.reduce(function(h,a){a.visible&&((a.options.data||[]).forEach(function(b){a.options.keys&&a.options.keys.length&&(b=a.pointClass.prototype.optionsToObject.call({series:a},b),a.pointClass.setGanttPointAliases(b));z(b,!0)&&(b.seriesIndex=f,h.push(b))}),!0===r&&f++);return h},[]);
if(n&&h.length<n)for(var w=h.length;w<=n;w++)h.push({name:w+"\u200b"});n=m(h,r||!1,!0===r?f:1);b.categories=n.categories;b.treeGrid.mapOfPosToGridNode=n.mapOfPosToGridNode;b.hasNames=!0;b.treeGrid.tree=n.tree;b.series.forEach(function(f){var a=(f.options.data||[]).map(function(a){g(a)&&f.options.keys&&f.options.keys.length&&h.forEach(function(f){0<=a.indexOf(f.x)&&0<=a.indexOf(f.x2)&&(a=f)});return z(a,!0)?H(a):a});f.visible&&f.setData(a,!1)});b.treeGrid.mapOptionsToLevel=k({defaults:e,from:1,levels:e&&
e.levels,to:b.treeGrid.tree&&b.treeGrid.tree.height});"beforeRender"===a.type&&(b.treeGrid.collapsedNodes=n.collapsedNodes)}})}function C(a,b){var n=this.treeGrid.mapOptionsToLevel||{},e=this.ticks,r=e[b],f;if("treegrid"===this.options.type&&this.treeGrid.mapOfPosToGridNode){var h=this.treeGrid.mapOfPosToGridNode[b];(n=n[h.depth])&&(f={labels:n});!r&&E?e[b]=new E(this,b,void 0,void 0,{category:h.name,tickmarkOffset:h.tickmarkOffset,options:f}):(r.parameters.category=h.name,r.options=f,r.addLabel())}else a.apply(this,
Array.prototype.slice.call(arguments,1))}function Q(a,b,n){var e=this,r="treegrid"===n.type;e.treeGrid||(e.treeGrid=new K(e));r&&(x(b,"beforeRender",p),x(b,"beforeRedraw",p),x(b,"addSeries",function(f){f.options.data&&(f=m(f.options.data,n.uniqueNames||!1,1),e.treeGrid.collapsedNodes=(e.treeGrid.collapsedNodes||[]).concat(f.collapsedNodes))}),x(e,"foundExtremes",function(){e.treeGrid.collapsedNodes&&e.treeGrid.collapsedNodes.forEach(function(f){var h=e.treeGrid.collapse(f);e.brokenAxis&&(e.brokenAxis.setBreaks(h,
!1),e.treeGrid.collapsedNodes&&(e.treeGrid.collapsedNodes=e.treeGrid.collapsedNodes.filter(function(h){return f.collapseStart!==h.collapseStart||f.collapseEnd!==h.collapseEnd})))})}),x(e,"afterBreaks",function(){"yAxis"===e.coll&&!e.staticScale&&e.chart.options.chart.height&&(e.isDirty=!0)}),n=H({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],symbol:{type:"triangle",x:-5,y:-5,height:10,width:10,padding:5}},uniqueNames:!1},n,{reversed:!0,grid:{columns:void 0}}));
a.apply(e,[b,n]);r&&(e.hasNames=!0,e.options.showLastLabel=!0)}function B(a){var b=this.options;"treegrid"===b.type?(this.min=e(this.userMin,b.min,this.dataMin),this.max=e(this.userMax,b.max,this.dataMax),q(this,"foundExtremes"),this.setAxisTranslation(),this.tickmarkOffset=.5,this.tickInterval=1,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():[]):a.apply(this,Array.prototype.slice.call(arguments,1))}var E;b.compose=function(b,e,n,d){-1===b.keepProps.indexOf("treeGrid")&&
(b.keepProps.push("treeGrid"),E=d,a(b.prototype,"generateTick",C),a(b.prototype,"init",Q),a(b.prototype,"setTickInterval",B),b.prototype.utils={getNode:v.getNode},t.compose(b,e,d),c.compose(b,n),u.compose(d));return b};var K=function(){function a(a){this.axis=a}a.prototype.setCollapsedStatus=function(a){var b=this.axis,e=b.chart;b.series.forEach(function(b){var f=b.options.data;if(a.id&&f){var h=e.get(a.id);b=f[b.data.indexOf(h)];h&&b&&(h.collapsed=a.collapsed,b.collapsed=a.collapsed)}})};a.prototype.collapse=
function(a){var b=this.axis,e=b.options.breaks||[],r=l(a,b.max);e.push(r);a.collapsed=!0;b.treeGrid.setCollapsedStatus(a);return e};a.prototype.expand=function(a){var b=this.axis,e=b.options.breaks||[],r=l(a,b.max);a.collapsed=!1;b.treeGrid.setCollapsedStatus(a);return e.reduce(function(f,a){a.to===r.to&&a.from===r.from||f.push(a);return f},[])};a.prototype.getTickPositions=function(){var a=this.axis,b=Math.floor(a.min/a.tickInterval)*a.tickInterval,e=Math.ceil(a.max/a.tickInterval)*a.tickInterval;
return Object.keys(a.treeGrid.mapOfPosToGridNode||{}).reduce(function(n,f){f=+f;!(f>=b&&f<=e)||a.brokenAxis&&a.brokenAxis.isInAnyBreak(f)||n.push(f);return n},[])};a.prototype.isCollapsed=function(a){var b=this.axis,e=b.options.breaks||[],r=l(a,b.max);return e.some(function(f){return f.from===r.from&&f.to===r.to})};a.prototype.toggleCollapse=function(a){return this.isCollapsed(a)?this.expand(a):this.collapse(a)};return a}();b.Additions=K})(b||(b={}));return b});J(c,"Extensions/CurrentDateIndication.js",
[c["Core/Axis/Axis.js"],c["Core/Axis/PlotLineOrBand/PlotLineOrBand.js"],c["Core/Utilities.js"]],function(c,t,v){var u=v.addEvent,B=v.merge;v=v.wrap;var m={color:"#ccd6eb",width:2,label:{format:"%a, %b %d %Y, %H:%M",formatter:function(c,m){return this.axis.chart.time.dateFormat(m||"",c)},rotation:0,style:{fontSize:"10px"}}};u(c,"afterSetOptions",function(){var c=this.options,x=c.currentDateIndicator;x&&(x="object"===typeof x?B(m,x):B(m),x.value=Date.now(),x.className="highcharts-current-date-indicator",
c.plotLines||(c.plotLines=[]),c.plotLines.push(x))});u(t,"render",function(){this.label&&this.label.attr({text:this.getLabelText(this.options.label)})});v(t.prototype,"getLabelText",function(c,m){var d=this.options;return d&&d.className&&-1!==d.className.indexOf("highcharts-current-date-indicator")&&d.label&&"function"===typeof d.label.formatter?(d.value=Date.now(),d.label.formatter.call(this,d.value,d.label.format)):c.call(this,m)})});J(c,"Extensions/StaticScale.js",[c["Core/Axis/Axis.js"],c["Core/Chart/Chart.js"],
c["Core/Utilities.js"]],function(c,t,v){var u=v.addEvent,B=v.defined,m=v.isNumber,k=v.pick;u(c,"afterSetOptions",function(){var c=this.chart.options.chart;!this.horiz&&m(this.options.staticScale)&&(!c.height||c.scrollablePlotArea&&c.scrollablePlotArea.minHeight)&&(this.staticScale=this.options.staticScale)});t.prototype.adjustHeight=function(){"adjustHeight"!==this.redrawTrigger&&((this.axes||[]).forEach(function(c){var d=c.chart,m=!!d.initiatedScale&&d.options.animation,g=c.options.staticScale;if(c.staticScale&&
B(c.min)){var z=k(c.brokenAxis&&c.brokenAxis.unitLength,c.max+c.tickInterval-c.min)*g;z=Math.max(z,g);g=z-d.plotHeight;!d.scrollablePixelsY&&1<=Math.abs(g)&&(d.plotHeight=z,d.redrawTrigger="adjustHeight",d.setSize(void 0,d.chartHeight+g,m));c.series.forEach(function(g){(g=g.sharedClipKey&&d.sharedClips[g.sharedClipKey])&&g.attr(d.inverted?{width:d.plotHeight}:{height:d.plotHeight})})}}),this.initiatedScale=!0);this.redrawTrigger=null};u(t,"render",t.prototype.adjustHeight)});J(c,"Extensions/ArrowSymbols.js",
[c["Core/Renderer/SVG/SVGRenderer.js"]],function(c){function t(c,m,k,t){return[["M",c,m+t/2],["L",c+k,m],["L",c,m+t/2],["L",c+k,m+t]]}function v(c,m,k,t){return[["M",c+k,m],["L",c,m+t/2],["L",c+k,m+t],["Z"]]}function u(c,m,k,t){return v(c,m,k/2,t)}c=c.prototype.symbols;c.arrow=t;c["arrow-filled"]=v;c["arrow-filled-half"]=u;c["arrow-half"]=function(c,m,k,u){return t(c,m,k/2,u)};c["triangle-left"]=v;c["triangle-left-half"]=u;return c});J(c,"Gantt/Connection.js",[c["Core/Globals.js"],c["Core/DefaultOptions.js"],
c["Core/Series/Point.js"],c["Core/Utilities.js"]],function(c,t,v,u){function B(d){var e=d.shapeArgs;return e?{xMin:e.x||0,xMax:(e.x||0)+(e.width||0),yMin:e.y||0,yMax:(e.y||0)+(e.height||0)}:(e=d.graphic&&d.graphic.getBBox())?{xMin:d.plotX-e.width/2,xMax:d.plotX+e.width/2,yMin:d.plotY-e.height/2,yMax:d.plotY+e.height/2}:null}"";var m=u.defined,k=u.error,x=u.extend,d=u.merge,q=u.objectEach,g=c.deg2rad,z=Math.max,D=Math.min;x(t.defaultOptions,{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,
align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});t=function(){function c(e,a,b){this.toPoint=this.pathfinder=this.graphics=this.fromPoint=this.chart=void 0;this.init(e,a,b)}c.prototype.init=function(e,a,b){this.fromPoint=e;this.toPoint=a;this.options=b;this.chart=e.series.chart;this.pathfinder=this.chart.pathfinder};c.prototype.renderPath=function(e,a,b){var d=this.chart,c=d.styledMode,g=d.pathfinder,p=!d.options.chart.forExport&&
!1!==b,k=this.graphics&&this.graphics.path;g.group||(g.group=d.renderer.g().addClass("highcharts-pathfinder-group").attr({zIndex:-1}).add(d.seriesGroup));g.group.translate(d.plotLeft,d.plotTop);k&&k.renderer||(k=d.renderer.path().add(g.group),c||k.attr({opacity:0}));k.attr(a);e={d:e};c||(e.opacity=1);k[p?"animate":"attr"](e,b);this.graphics=this.graphics||{};this.graphics.path=k};c.prototype.addMarker=function(e,a,b){var d=this.fromPoint.series.chart,c=d.pathfinder;d=d.renderer;var k="start"===e?
this.fromPoint:this.toPoint,p=k.getPathfinderAnchorPoint(a);if(a.enabled&&((b="start"===e?b[1]:b[b.length-2])&&"M"===b[0]||"L"===b[0])){b={x:b[1],y:b[2]};b=k.getRadiansToVector(b,p);p=k.getMarkerVector(b,a.radius,p);b=-b/g;if(a.width&&a.height){var m=a.width;var z=a.height}else m=z=2*a.radius;this.graphics=this.graphics||{};p={x:p.x-m/2,y:p.y-z/2,width:m,height:z,rotation:b,rotationOriginX:p.x,rotationOriginY:p.y};this.graphics[e]?this.graphics[e].animate(p):(this.graphics[e]=d.symbol(a.symbol).addClass("highcharts-point-connecting-path-"+
e+"-marker").attr(p).add(c.group),d.styledMode||this.graphics[e].attr({fill:a.color||this.fromPoint.color,stroke:a.lineColor,"stroke-width":a.lineWidth,opacity:0}).animate({opacity:1},k.series.options.animation))}};c.prototype.getPath=function(e){var a=this.pathfinder,b=this.chart,c=a.algorithms[e.type],g=a.chartObstacles;if("function"!==typeof c)return k('"'+e.type+'" is not a Pathfinder algorithm.'),{path:[],obstacles:[]};c.requiresObstacles&&!g&&(g=a.chartObstacles=a.getChartObstacles(e),b.options.connectors.algorithmMargin=
e.algorithmMargin,a.chartObstacleMetrics=a.getObstacleMetrics(g));return c(this.fromPoint.getPathfinderAnchorPoint(e.startMarker),this.toPoint.getPathfinderAnchorPoint(e.endMarker),d({chartObstacles:g,lineObstacles:a.lineObstacles||[],obstacleMetrics:a.chartObstacleMetrics,hardBounds:{xMin:0,xMax:b.plotWidth,yMin:0,yMax:b.plotHeight},obstacleOptions:{margin:e.algorithmMargin},startDirectionX:a.getAlgorithmStartDirection(e.startMarker)},e))};c.prototype.render=function(){var e=this.fromPoint,a=e.series,
b=a.chart,c=b.pathfinder,g=d(b.options.connectors,a.options.connectors,e.options.connectors,this.options),k={};b.styledMode||(k.stroke=g.lineColor||e.color,k["stroke-width"]=g.lineWidth,g.dashStyle&&(k.dashstyle=g.dashStyle));k["class"]="highcharts-point-connecting-path highcharts-color-"+e.colorIndex;g=d(k,g);m(g.marker.radius)||(g.marker.radius=D(z(Math.ceil((g.algorithmMargin||8)/2)-1,1),5));e=this.getPath(g);b=e.path;e.obstacles&&(c.lineObstacles=c.lineObstacles||[],c.lineObstacles=c.lineObstacles.concat(e.obstacles));
this.renderPath(b,k,a.options.animation);this.addMarker("start",d(g.marker,g.startMarker),b);this.addMarker("end",d(g.marker,g.endMarker),b)};c.prototype.destroy=function(){this.graphics&&(q(this.graphics,function(e){e.destroy()}),delete this.graphics)};return c}();c.Connection=t;x(v.prototype,{getPathfinderAnchorPoint:function(d){var e=B(this);switch(d.align){case "right":var a="xMax";break;case "left":a="xMin"}switch(d.verticalAlign){case "top":var b="yMin";break;case "bottom":b="yMax"}return{x:a?
e[a]:(e.xMin+e.xMax)/2,y:b?e[b]:(e.yMin+e.yMax)/2}},getRadiansToVector:function(d,e){var a;m(e)||(a=B(this))&&(e={x:(a.xMin+a.xMax)/2,y:(a.yMin+a.yMax)/2});return Math.atan2(e.y-d.y,d.x-e.x)},getMarkerVector:function(d,e,a){var b=2*Math.PI,c=B(this),g=c.xMax-c.xMin,k=c.yMax-c.yMin,p=Math.atan2(k,g),m=!1;g/=2;var z=k/2,q=c.xMin+g;c=c.yMin+z;for(var D=q,t=c,u=1,A=1;d<-Math.PI;)d+=b;for(;d>Math.PI;)d-=b;b=Math.tan(d);d>-p&&d<=p?(A=-1,m=!0):d>p&&d<=Math.PI-p?A=-1:d>Math.PI-p||d<=-(Math.PI-p)?(u=-1,m=
!0):u=-1;m?(D+=u*g,t+=A*g*b):(D+=k/(2*b)*u,t+=A*z);a.x!==q&&(D=a.x);a.y!==c&&(t=a.y);return{x:D+e*Math.cos(d),y:t-e*Math.sin(d)}}});return t});J(c,"Gantt/PathfinderAlgorithms.js",[c["Core/Utilities.js"]],function(c){function t(d,c,k){k=k||0;var g=d.length-1;c-=1e-7;for(var e,a;k<=g;)if(e=g+k>>1,a=c-d[e].xMin,0<a)k=e+1;else if(0>a)g=e-1;else return e;return 0<k?k-1:0}function v(d,c){for(var g=t(d,c.x+1)+1;g--;){var k;if(k=d[g].xMax>=c.x)k=d[g],k=c.x<=k.xMax&&c.x>=k.xMin&&c.y<=k.yMax&&c.y>=k.yMin;if(k)return g}return-1}
function u(d){var c=[];if(d.length){c.push(["M",d[0].start.x,d[0].start.y]);for(var g=0;g<d.length;++g)c.push(["L",d[g].end.x,d[g].end.y])}return c}function B(d,c){d.yMin=x(d.yMin,c.yMin);d.yMax=k(d.yMax,c.yMax);d.xMin=x(d.xMin,c.xMin);d.xMax=k(d.xMax,c.xMax)}var m=c.pick,k=Math.min,x=Math.max,d=Math.abs;c=function(c,k,q){function g(a,b,d,e,c){a={x:a.x,y:a.y};a[b]=d[e||b]+(c||0);return a}function e(a,b,e){var c=d(b[e]-a[e+"Min"])>d(b[e]-a[e+"Max"]);return g(b,e,a,e+(c?"Max":"Min"),c?1:-1)}var a=[],
b=m(q.startDirectionX,d(k.x-c.x)>d(k.y-c.y))?"x":"y",l=q.chartObstacles,z=v(l,c);q=v(l,k);if(-1<q){var t=l[q];q=e(t,k,b);t={start:q,end:k};var p=q}else p=k;-1<z&&(l=l[z],q=e(l,c,b),a.push({start:c,end:q}),q[b]>=c[b]===q[b]>=p[b]&&(b="y"===b?"x":"y",k=c[b]<k[b],a.push({start:q,end:g(q,b,l,b+(k?"Max":"Min"),k?1:-1)}),b="y"===b?"x":"y"));c=a.length?a[a.length-1].end:c;q=g(c,b,p);a.push({start:c,end:q});b=g(q,"y"===b?"x":"y",p);a.push({start:q,end:b});a.push(t);return{path:u(a),obstacles:a}};c.requiresObstacles=
!0;var q=function(c,q,D){function g(a,b,f){var h,c=a.x<b.x?1:-1;if(a.x<b.x){var e=a;var d=b}else e=b,d=a;if(a.y<b.y){var n=a;var r=b}else n=b,r=a;for(h=0>c?k(t(I,d.x),I.length-1):0;I[h]&&(0<c&&I[h].xMin<=d.x||0>c&&I[h].xMax>=e.x);){if(I[h].xMin<=d.x&&I[h].xMax>=e.x&&I[h].yMin<=r.y&&I[h].yMax>=n.y)return f?{y:a.y,x:a.x<b.x?I[h].xMin-1:I[h].xMax+1,obstacle:I[h]}:{x:a.x,y:a.y<b.y?I[h].yMin-1:I[h].yMax+1,obstacle:I[h]};h+=c}return b}function e(a,b,f,h,c){var e=c.soft,n=c.hard,r=h?"x":"y",w={x:b.x,y:b.y},
l={x:b.x,y:b.y};c=a[r+"Max"]>=e[r+"Max"];e=a[r+"Min"]<=e[r+"Min"];var p=a[r+"Max"]>=n[r+"Max"];n=a[r+"Min"]<=n[r+"Min"];var k=d(a[r+"Min"]-b[r]),y=d(a[r+"Max"]-b[r]);f=10>d(k-y)?b[r]<f[r]:y<k;l[r]=a[r+"Min"];w[r]=a[r+"Max"];a=g(b,l,h)[r]!==l[r];b=g(b,w,h)[r]!==w[r];f=a?b?f:!0:b?!1:f;f=e?c?f:!0:c?!1:f;return n?p?f:!0:p?!1:f}function a(b,c,f){if(b.x===c.x&&b.y===c.y)return[];var h=f?"x":"y",d=D.obstacleOptions.margin;var n={soft:{xMin:Q,xMax:M,yMin:E,yMax:K},hard:D.hardBounds};var r=v(I,b);if(-1<r){r=
I[r];n=e(r,b,c,f,n);B(r,D.hardBounds);var l=f?{y:b.y,x:r[n?"xMax":"xMin"]+(n?1:-1)}:{x:b.x,y:r[n?"yMax":"yMin"]+(n?1:-1)};var y=v(I,l);-1<y&&(y=I[y],B(y,D.hardBounds),l[h]=n?x(r[h+"Max"]-d+1,(y[h+"Min"]+r[h+"Max"])/2):k(r[h+"Min"]+d-1,(y[h+"Max"]+r[h+"Min"])/2),b.x===l.x&&b.y===l.y?(p&&(l[h]=n?x(r[h+"Max"],y[h+"Max"])+1:k(r[h+"Min"],y[h+"Min"])-1),p=!p):p=!1);b=[{start:b,end:l}]}else h=g(b,{x:f?c.x:b.x,y:f?b.y:c.y},f),b=[{start:b,end:{x:h.x,y:h.y}}],h[f?"x":"y"]!==c[f?"x":"y"]&&(n=e(h.obstacle,h,
c,!f,n),B(h.obstacle,D.hardBounds),n={x:f?h.x:h.obstacle[n?"xMax":"xMin"]+(n?1:-1),y:f?h.obstacle[n?"yMax":"yMin"]+(n?1:-1):h.y},f=!f,b=b.concat(a({x:h.x,y:h.y},n,f)));return b=b.concat(a(b[b.length-1].end,c,!f))}function b(a,b,f){var h=k(a.xMax-b.x,b.x-a.xMin)<k(a.yMax-b.y,b.y-a.yMin);f=e(a,b,f,h,{soft:D.hardBounds,hard:D.hardBounds});return h?{y:b.y,x:a[f?"xMax":"xMin"]+(f?1:-1)}:{x:b.x,y:a[f?"yMax":"yMin"]+(f?1:-1)}}var l=m(D.startDirectionX,d(q.x-c.x)>d(q.y-c.y)),z=l?"x":"y",G=[],p=!1,C=D.obstacleMetrics,
Q=k(c.x,q.x)-C.maxWidth-10,M=x(c.x,q.x)+C.maxWidth+10,E=k(c.y,q.y)-C.maxHeight-10,K=x(c.y,q.y)+C.maxHeight+10,I=D.chartObstacles;var A=t(I,Q);C=t(I,M);I=I.slice(A,C+1);if(-1<(C=v(I,q))){var n=b(I[C],q,c);G.push({end:q,start:n});q=n}for(;-1<(C=v(I,q));)A=0>q[z]-c[z],n={x:q.x,y:q.y},n[z]=I[C][A?z+"Max":z+"Min"]+(A?1:-1),G.push({end:q,start:n}),q=n;c=a(c,q,l);c=c.concat(G.reverse());return{path:u(c),obstacles:c}};q.requiresObstacles=!0;return{fastAvoid:q,straight:function(c,d){return{path:[["M",c.x,
c.y],["L",d.x,d.y]],obstacles:[{start:c,end:d}]}},simpleConnect:c}});J(c,"Gantt/Pathfinder.js",[c["Gantt/Connection.js"],c["Core/Chart/Chart.js"],c["Core/Globals.js"],c["Core/DefaultOptions.js"],c["Core/Series/Point.js"],c["Core/Utilities.js"],c["Gantt/PathfinderAlgorithms.js"]],function(c,t,v,u,B,m,k){function x(a){var b=a.shapeArgs;return b?{xMin:b.x||0,xMax:(b.x||0)+(b.width||0),yMin:b.y||0,yMax:(b.y||0)+(b.height||0)}:(b=a.graphic&&a.graphic.getBBox())?{xMin:a.plotX-b.width/2,xMax:a.plotX+b.width/
2,yMin:a.plotY-b.height/2,yMax:a.plotY+b.height/2}:null}function d(b){for(var c=b.length,d=0,e,g,k=[],p=function(b,c,d){d=a(d,10);var e=b.yMax+d>c.yMin-d&&b.yMin-d<c.yMax+d,f=b.xMax+d>c.xMin-d&&b.xMin-d<c.xMax+d,h=e?b.xMin>c.xMax?b.xMin-c.xMax:c.xMin-b.xMax:Infinity,n=f?b.yMin>c.yMax?b.yMin-c.yMax:c.yMin-b.yMax:Infinity;return f&&e?d?p(b,c,Math.floor(d/2)):Infinity:F(h,n)};d<c;++d)for(e=d+1;e<c;++e)g=p(b[d],b[e]),80>g&&k.push(g);k.push(80);return l(Math.floor(k.sort(function(a,b){return a-b})[Math.floor(k.length/
10)]/2-1),1)}function q(a){if(a.options.pathfinder||a.series.reduce(function(a,b){b.options&&e(!0,b.options.connectors=b.options.connectors||{},b.options.pathfinder);return a||b.options&&b.options.pathfinder},!1))e(!0,a.options.connectors=a.options.connectors||{},a.options.pathfinder),D('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.')}"";var g=m.addEvent,z=m.defined,D=m.error,H=m.extend,e=m.merge,a=m.pick,b=m.splat,l=Math.max,F=Math.min;H(u.defaultOptions,
{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});var G=function(){function e(a){this.lineObstacles=this.group=this.connections=this.chartObstacleMetrics=this.chartObstacles=this.chart=void 0;this.init(a)}e.prototype.init=function(a){this.chart=a;this.connections=[];g(a,"redraw",function(){this.pathfinder.update()})};e.prototype.update=function(a){var d=this.chart,
e=this,g=e.connections;e.connections=[];d.series.forEach(function(a){a.visible&&!a.options.isInternal&&a.points.forEach(function(f){var a=f.options;a&&a.dependency&&(a.connect=a.dependency);var n;a=f.options&&f.options.connect&&b(f.options.connect);f.visible&&!1!==f.isInside&&a&&a.forEach(function(a){n=d.get("string"===typeof a?a:a.to);n instanceof B&&n.series.visible&&n.visible&&!1!==n.isInside&&e.connections.push(new c(f,n,"string"===typeof a?{}:a))})})});for(var l=0,k=void 0,p=void 0,n=g.length,
y=e.connections.length;l<n;++l){p=!1;for(k=0;k<y;++k)if(g[l].fromPoint===e.connections[k].fromPoint&&g[l].toPoint===e.connections[k].toPoint){e.connections[k].graphics=g[l].graphics;p=!0;break}p||g[l].destroy()}delete this.chartObstacles;delete this.lineObstacles;e.renderConnections(a)};e.prototype.renderConnections=function(a){a?this.chart.series.forEach(function(a){var b=function(){var b=a.chart.pathfinder;(b&&b.connections||[]).forEach(function(b){b.fromPoint&&b.fromPoint.series===a&&b.render()});
a.pathfinderRemoveRenderEvent&&(a.pathfinderRemoveRenderEvent(),delete a.pathfinderRemoveRenderEvent)};!1===a.options.animation?b():a.pathfinderRemoveRenderEvent=g(a,"afterAnimate",b)}):this.connections.forEach(function(a){a.render()})};e.prototype.getChartObstacles=function(b){for(var c=[],e=this.chart.series,g=a(b.algorithmMargin,0),l,k=0,p=e.length;k<p;++k)if(e[k].visible&&!e[k].options.isInternal){var n=0,y=e[k].points.length,r=void 0;for(r=void 0;n<y;++n)r=e[k].points[n],r.visible&&(r=x(r))&&
c.push({xMin:r.xMin-g,xMax:r.xMax+g,yMin:r.yMin-g,yMax:r.yMax+g})}c=c.sort(function(f,a){return f.xMin-a.xMin});z(b.algorithmMargin)||(l=b.algorithmMargin=d(c),c.forEach(function(f){f.xMin-=l;f.xMax+=l;f.yMin-=l;f.yMax+=l}));return c};e.prototype.getObstacleMetrics=function(a){for(var b=0,c=0,e,d,g=a.length;g--;)e=a[g].xMax-a[g].xMin,d=a[g].yMax-a[g].yMin,b<e&&(b=e),c<d&&(c=d);return{maxHeight:c,maxWidth:b}};e.prototype.getAlgorithmStartDirection=function(a){var b="top"!==a.verticalAlign&&"bottom"!==
a.verticalAlign;return"left"!==a.align&&"right"!==a.align?b?void 0:!1:b?!0:void 0};return e}();G.prototype.algorithms=k;v.Pathfinder=G;H(B.prototype,{getPathfinderAnchorPoint:function(a){var b=x(this);switch(a.align){case "right":var c="xMax";break;case "left":c="xMin"}switch(a.verticalAlign){case "top":var e="yMin";break;case "bottom":e="yMax"}return{x:c?b[c]:(b.xMin+b.xMax)/2,y:e?b[e]:(b.yMin+b.yMax)/2}},getRadiansToVector:function(a,b){var c;z(b)||(c=x(this))&&(b={x:(c.xMin+c.xMax)/2,y:(c.yMin+
c.yMax)/2});return Math.atan2(b.y-a.y,a.x-b.x)},getMarkerVector:function(a,b,c){var e=2*Math.PI,d=x(this),g=d.xMax-d.xMin,l=d.yMax-d.yMin,k=Math.atan2(l,g),n=!1;g/=2;var p=l/2,r=d.xMin+g;d=d.yMin+p;for(var f=r,h=d,w=1,L=1;a<-Math.PI;)a+=e;for(;a>Math.PI;)a-=e;e=Math.tan(a);a>-k&&a<=k?(L=-1,n=!0):a>k&&a<=Math.PI-k?L=-1:a>Math.PI-k||a<=-(Math.PI-k)?(w=-1,n=!0):w=-1;n?(f+=w*g,h+=L*g*e):(f+=l/(2*e)*w,h+=L*p);c.x!==r&&(f=c.x);c.y!==d&&(h=c.y);return{x:f+b*Math.cos(a),y:h-b*Math.sin(a)}}});t.prototype.callbacks.push(function(a){!1!==
a.options.connectors.enabled&&(q(a),this.pathfinder=new G(this),this.pathfinder.update(!0))});return G});J(c,"Series/Gantt/GanttSeries.js",[c["Core/Axis/Axis.js"],c["Core/Chart/Chart.js"],c["Series/Gantt/GanttPoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Axis/Tick.js"],c["Core/Utilities.js"],c["Core/Axis/TreeGridAxis.js"]],function(c,t,v,u,B,m,k){var x=this&&this.__extends||function(){var c=function(e,a){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||
function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return c(e,a)};return function(e,a){function b(){this.constructor=e}c(e,a);e.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),d=u.series,q=u.seriesTypes.xrange,g=m.extend,z=m.isNumber,D=m.merge;k.compose(c,t,d,B);c=function(c){function e(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}x(e,c);e.prototype.drawPoint=function(a,b){var c=this.options,e=this.chart.renderer,
d=a.shapeArgs,g=a.plotY,k=a.graphic,m=a.selected&&"select",t=c.stacking&&!c.borderRadius;if(a.options.milestone)if(z(g)&&null!==a.y&&!1!==a.visible){d=e.symbols.diamond(d.x||0,d.y||0,d.width||0,d.height||0);if(k)k[b]({d:d});else a.graphic=e.path(d).addClass(a.getClassName(),!0).add(a.group||this.group);this.chart.styledMode||a.graphic.attr(this.pointAttribs(a,m)).shadow(c.shadow,null,t)}else k&&(a.graphic=k.destroy());else q.prototype.drawPoint.call(this,a,b)};e.prototype.translatePoint=function(a){q.prototype.translatePoint.call(this,
a);if(a.options.milestone){var b=a.shapeArgs;var c=b.height||0;a.shapeArgs={x:(b.x||0)-c/2,y:b.y,width:c,height:c}}};e.defaultOptions=D(q.defaultOptions,{grouping:!1,dataLabels:{enabled:!0},tooltip:{headerFormat:'<span style="font-size: 10px">{series.name}</span><br/>',pointFormat:null,pointFormatter:function(){var a=this.series,b=a.xAxis,c=a.tooltipOptions.dateTimeLabelFormats,e=b.options.startOfWeek,d=a.tooltipOptions,g=d.xDateFormat,k=this.options.milestone,m="<b>"+(this.name||this.yCategory)+
"</b>";if(d.pointFormat)return this.tooltipFormatter(d.pointFormat);!g&&z(this.start)&&(g=a.chart.time.getDateFormat(b.closestPointRange,this.start,e,c||{}));b=a.chart.time.dateFormat(g,this.start);a=a.chart.time.dateFormat(g,this.end);m+="<br/>";return k?m+(b+"<br/>"):m+("Start: "+b+"<br/>End: ")+(a+"<br/>")}},connectors:{type:"simpleConnect",animation:{reversed:!0},startMarker:{enabled:!0,symbol:"arrow-filled",radius:4,fill:"#fa0",align:"left"},endMarker:{enabled:!1,align:"right"}}});return e}(q);
g(c.prototype,{pointArrayMap:["start","end","y"],pointClass:v,setData:d.prototype.setData});u.registerSeriesType("gantt",c);"";return c});J(c,"Core/Chart/GanttChart.js",[c["Core/Chart/Chart.js"],c["Core/DefaultOptions.js"],c["Core/Utilities.js"]],function(c,t,v){var u=this&&this.__extends||function(){var c=function(d,g){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,d){c.__proto__=d}||function(c,d){for(var g in d)d.hasOwnProperty(g)&&(c[g]=d[g])};return c(d,g)};return function(d,
g){function k(){this.constructor=d}c(d,g);d.prototype=null===g?Object.create(g):(k.prototype=g.prototype,new k)}}(),B=t.getOptions,m=v.isArray,k=v.merge,x=v.splat;c=function(c){function d(){return null!==c&&c.apply(this,arguments)||this}u(d,c);d.prototype.init=function(d,q){var g=B(),t=d.xAxis,e=d.yAxis,a;d.xAxis=d.yAxis=void 0;var b=k(!0,{chart:{type:"gantt"},title:{text:null},legend:{enabled:!1},navigator:{series:{type:"gantt"},yAxis:{type:"category"}}},d,{isGantt:!0});d.xAxis=t;d.yAxis=e;b.xAxis=
(m(d.xAxis)?d.xAxis:[d.xAxis||{},{}]).map(function(b,c){1===c&&(a=0);return k(g.xAxis,{grid:{enabled:!0},opposite:!0,linkedTo:a},b,{type:"datetime"})});b.yAxis=x(d.yAxis||{}).map(function(a){return k(g.yAxis,{grid:{enabled:!0},staticScale:50,reversed:!0,type:a.categories?a.type:"treegrid"},a)});c.prototype.init.call(this,b,q)};return d}(c);(function(c){c.ganttChart=function(d,g,k){return new c(d,g,k)}})(c||(c={}));return c});J(c,"Core/Axis/ScrollbarAxis.js",[c["Core/Utilities.js"]],function(c){var t=
c.addEvent,v=c.defined,u=c.pick;return function(){function c(){}c.compose=function(m,k){if(-1===c.composed.indexOf(m))c.composed.push(m);else return m;var x=function(c){var d=u(c.options&&c.options.min,c.min),g=u(c.options&&c.options.max,c.max);return{axisMin:d,axisMax:g,scrollMin:v(c.dataMin)?Math.min(d,c.min,c.dataMin,u(c.threshold,Infinity)):d,scrollMax:v(c.dataMax)?Math.max(g,c.max,c.dataMax,u(c.threshold,-Infinity)):g}};t(m,"afterInit",function(){var c=this;c.options&&c.options.scrollbar&&c.options.scrollbar.enabled&&
(c.options.scrollbar.vertical=!c.horiz,c.options.startOnTick=c.options.endOnTick=!1,c.scrollbar=new k(c.chart.renderer,c.options.scrollbar,c.chart),t(c.scrollbar,"changed",function(d){var g=x(c),k=g.axisMax,m=g.scrollMin,q=g.scrollMax-m;v(g.axisMin)&&v(k)&&(c.horiz&&!c.reversed||!c.horiz&&c.reversed?(g=m+q*this.to,m+=q*this.from):(g=m+q*(1-this.from),m+=q*(1-this.to)),this.shouldUpdateExtremes(d.DOMType)?c.setExtremes(m,g,!0,"mousemove"!==d.DOMType&&"touchmove"!==d.DOMType,d):this.setRange(this.from,
this.to))}))});t(m,"afterRender",function(){var c=x(this),k=c.scrollMin,g=c.scrollMax;c=this.scrollbar;var m=this.axisTitleMargin+(this.titleOffset||0),t=this.chart.scrollbarsOffsets,u=this.options.margin||0;c&&(this.horiz?(this.opposite||(t[1]+=m),c.position(this.left,this.top+this.height+2+t[1]-(this.opposite?u:0),this.width,this.height),this.opposite||(t[1]+=u),m=1):(this.opposite&&(t[0]+=m),c.position(c.options.opposite?this.left+this.width+2+t[0]-(this.opposite?0:u):this.opposite?0:u,this.top,
this.width,this.height),this.opposite&&(t[0]+=u),m=0),t[m]+=c.size+c.options.margin,isNaN(k)||isNaN(g)||!v(this.min)||!v(this.max)||this.min===this.max?c.setRange(0,1):(t=(this.min-k)/(g-k),k=(this.max-k)/(g-k),this.horiz&&!this.reversed||!this.horiz&&this.reversed?c.setRange(t,k):c.setRange(1-k,1-t)))});t(m,"afterGetOffset",function(){var c=this.scrollbar&&!this.scrollbar.options.opposite;c=this.horiz?2:c?3:1;var k=this.scrollbar;k&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[c]+=k.size+
k.options.margin)});return m};c.composed=[];return c}()});J(c,"Core/ScrollbarDefaults.js",[c["Core/Globals.js"]],function(c){return{height:c.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",
trackBorderWidth:1}});J(c,"Core/Scrollbar.js",[c["Core/DefaultOptions.js"],c["Core/Globals.js"],c["Core/Axis/ScrollbarAxis.js"],c["Core/ScrollbarDefaults.js"],c["Core/Utilities.js"]],function(c,t,v,u,B){var m=c.defaultOptions,k=B.addEvent,x=B.correctFloat,d=B.defined,q=B.destroyObjectProperties,g=B.fireEvent,z=B.merge,D=B.pick,H=B.removeEvent;c=function(){function c(a,b,c){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=this.options=this.group=void 0;
this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(a,b,c)}c.compose=function(a){v.compose(a,c)};c.swapXY=function(a,b){b&&a.forEach(function(a){for(var b=a.length,c,e=0;e<b;e+=2)c=a[e+1],"number"===typeof c&&(a[e+1]=a[e+2],a[e+2]=c)});return a};c.prototype.addEvents=function(){var a=this.options.inverted?
[1,0]:[0,1],b=this.scrollbarButtons,c=this.scrollbarGroup.element,e=this.track.element,d=this.mouseDownHandler.bind(this),g=this.mouseMoveHandler.bind(this),m=this.mouseUpHandler.bind(this);a=[[b[a[0]].element,"click",this.buttonToMinClick.bind(this)],[b[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[e,"click",this.trackClick.bind(this)],[c,"mousedown",d],[c.ownerDocument,"mousemove",g],[c.ownerDocument,"mouseup",m]];t.hasTouch&&a.push([c,"touchstart",d],[c.ownerDocument,"touchmove",g],
[c.ownerDocument,"touchend",m]);a.forEach(function(a){k.apply(null,a)});this._events=a};c.prototype.buttonToMaxClick=function(a){var b=(this.to-this.from)*D(this.options.step,.2);this.updatePosition(this.from+b,this.to+b);g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};c.prototype.buttonToMinClick=function(a){var b=x(this.to-this.from)*D(this.options.step,.2);this.updatePosition(x(this.from-b),x(this.to-b));g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",
DOMEvent:a})};c.prototype.cursorToScrollbarPosition=function(a){var b=this.options;b=b.minWidth>this.calculatedWidth?b.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-b),chartY:(a.chartY-this.y-this.yOffset)/(this.barWidth-b)}};c.prototype.destroy=function(){var a=this,b=a.chart.scroller;a.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(b){a[b]&&a[b].destroy&&(a[b]=a[b].destroy())});b&&a===b.scrollbar&&(b.scrollbar=null,q(b.scrollbarButtons))};
c.prototype.drawScrollbarButton=function(a){var b=this.renderer,e=this.scrollbarButtons,d=this.options,g=this.size,k=b.g().add(this.group);e.push(k);k=b.rect().addClass("highcharts-scrollbar-button").add(k);this.chart.styledMode||k.attr({stroke:d.buttonBorderColor,"stroke-width":d.buttonBorderWidth,fill:d.buttonBackgroundColor});k.attr(k.crisp({x:-.5,y:-.5,width:g+1,height:g+1,r:d.buttonBorderRadius},k.strokeWidth()));k=b.path(c.swapXY([["M",g/2+(a?-1:1),g/2-3],["L",g/2+(a?-1:1),g/2+3],["L",g/2+(a?
2:-2),g/2]],d.vertical)).addClass("highcharts-scrollbar-arrow").add(e[a]);this.chart.styledMode||k.attr({fill:d.buttonArrowColor})};c.prototype.init=function(a,b,c){this.scrollbarButtons=[];this.renderer=a;this.userOptions=b;this.options=z(u,m.scrollbar,b);this.chart=c;this.size=D(this.options.size,this.options.height);b.enabled&&(this.render(),this.addEvents())};c.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);this.chartX=a.chartX;this.chartY=
a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};c.prototype.mouseMoveHandler=function(a){var b=this.chart.pointer.normalize(a),c=this.options.vertical?"chartY":"chartX",e=this.initPositions||[];!this.grabbedCenter||a.touches&&0===a.touches[0][c]||(b=this.cursorToScrollbarPosition(b)[c],c=this[c],c=b-c,this.hasDragged=!0,this.updatePosition(e[0]+c,e[1]+c),this.hasDragged&&g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a}))};c.prototype.mouseUpHandler=
function(a){this.hasDragged&&g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};c.prototype.position=function(a,b,c,e){var d=this.options.vertical,g=this.rendered?"animate":"attr",k=0;this.x=a;this.y=b+this.trackBorderWidth;this.width=c;this.xOffset=this.height=e;this.yOffset=k;d?(this.width=this.yOffset=c=k=this.size,this.xOffset=b=0,this.barWidth=e-2*c,this.x=a+=this.options.margin):(this.height=
this.xOffset=e=b=this.size,this.barWidth=c-2*e,this.y+=this.options.margin);this.group[g]({translateX:a,translateY:this.y});this.track[g]({width:c,height:e});this.scrollbarButtons[1][g]({translateX:d?0:c-b,translateY:d?e-k:0})};c.prototype.removeEvents=function(){this._events.forEach(function(a){H.apply(null,a)});this._events.length=0};c.prototype.render=function(){var a=this.renderer,b=this.options,e=this.size,d=this.chart.styledMode,g=a.g("scrollbar").attr({zIndex:b.zIndex,translateY:-99999}).add();
this.group=g;this.track=a.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:b.trackBorderRadius||0,height:e,width:e}).add(g);d||this.track.attr({fill:b.trackBackgroundColor,stroke:b.trackBorderColor,"stroke-width":b.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=a.g().add(g);this.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:e,width:e,r:b.barBorderRadius||0}).add(this.scrollbarGroup);
this.scrollbarRifles=a.path(c.swapXY([["M",-3,e/4],["L",-3,2*e/3],["M",0,e/4],["L",0,2*e/3],["M",3,e/4],["L",3,2*e/3]],b.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);d||(this.scrollbar.attr({fill:b.barBackgroundColor,stroke:b.barBorderColor,"stroke-width":b.barBorderWidth}),this.scrollbarRifles.attr({stroke:b.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%
2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};c.prototype.setRange=function(a,b){var c=this.options,e=c.vertical,g=c.minWidth,k=this.barWidth,m=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(d(k)){var q=k*Math.min(b,1);a=Math.max(a,0);var t=Math.ceil(k*a);this.calculatedWidth=q=x(q-t);q<g&&(t=(k-g+q)*a,q=g);g=Math.floor(t+this.xOffset+this.yOffset);k=q/2-.5;this.from=a;this.to=b;e?(this.scrollbarGroup[m]({translateY:g}),this.scrollbar[m]({height:q}),
this.scrollbarRifles[m]({translateY:k}),this.scrollbarTop=g,this.scrollbarLeft=0):(this.scrollbarGroup[m]({translateX:g}),this.scrollbar[m]({width:q}),this.scrollbarRifles[m]({translateX:k}),this.scrollbarLeft=g,this.scrollbarTop=0);12>=q?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===c.showFull&&(0>=a&&1<=b?this.group.hide():this.group.show());this.rendered=!0}};c.prototype.shouldUpdateExtremes=function(a){return D(this.options.liveRedraw,t.svg&&!t.isTouchDevice&&!this.chart.isBoosting)||
"mouseup"===a||"touchend"===a||!d(a)};c.prototype.trackClick=function(a){var b=this.chart.pointer.normalize(a),c=this.to-this.from,e=this.y+this.scrollbarTop,d=this.x+this.scrollbarLeft;this.options.vertical&&b.chartY>e||!this.options.vertical&&b.chartX>d?this.updatePosition(this.from+c,this.to+c):this.updatePosition(this.from-c,this.to-c);g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};c.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,z(!0,
this.options,a),this.chart)};c.prototype.updatePosition=function(a,b){1<b&&(a=x(1-x(b-a)),b=1);0>a&&(b=x(b-a),a=0);this.from=a;this.to=b};c.defaultOptions=u;return c}();m.scrollbar=z(!0,c.defaultOptions,m.scrollbar);return c});J(c,"Extensions/RangeSelector.js",[c["Core/Axis/Axis.js"],c["Core/Chart/Chart.js"],c["Core/Globals.js"],c["Core/DefaultOptions.js"],c["Core/Renderer/SVG/SVGElement.js"],c["Core/Utilities.js"]],function(c,t,v,u,B,m){function k(a){if(-1!==a.indexOf("%L"))return"text";var b="aAdewbBmoyY".split("").some(function(b){return-1!==
a.indexOf("%"+b)}),c="HkIlMS".split("").some(function(b){return-1!==a.indexOf("%"+b)});return b&&c?"datetime-local":b?"date":c?"time":"text"}var x=u.defaultOptions,d=m.addEvent,q=m.createElement,g=m.css,z=m.defined,D=m.destroyObjectProperties,H=m.discardElement,e=m.extend,a=m.find,b=m.fireEvent,l=m.isNumber,F=m.merge,G=m.objectEach,p=m.pad,C=m.pick,J=m.pInt,M=m.splat;e(x,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,
height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#335cad",cursor:"pointer"},labelStyle:{color:"#666666"}}});e(x.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"});var E=
function(){function a(b){this.buttons=void 0;this.buttonOptions=a.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=b;this.init(b)}a.prototype.clickButton=function(a,e){var n=this.chart,f=this.buttonOptions[a],h=n.xAxis[0],g=n.scroller&&n.scroller.getUnionExtremes()||h||{},k=g.dataMin,m=g.dataMax,y=h&&Math.round(Math.min(h.max,C(m,h.max))),p=f.type;g=f._range;var q,t=f.dataGrouping;if(null!==k&&null!==m){n.fixedRange=g;this.setSelected(a);t&&(this.forcedDataGrouping=
!0,c.prototype.setDataGrouping.call(h||{chart:this.chart},t,!1),this.frozenStates=f.preserveDataGrouping);if("month"===p||"year"===p)if(h){p={range:f,max:y,chart:n,dataMin:k,dataMax:m};var u=h.minFromRange.call(p);l(p.newMax)&&(y=p.newMax)}else g=f;else if(g)u=Math.max(y-g,k),y=Math.min(u+g,m);else if("ytd"===p)if(h)"undefined"===typeof m&&(k=Number.MAX_VALUE,m=Number.MIN_VALUE,n.series.forEach(function(a){a=a.xData;k=Math.min(a[0],k);m=Math.max(a[a.length-1],m)}),e=!1),y=this.getYTDExtremes(m,k,
n.time.useUTC),u=q=y.min,y=y.max;else{this.deferredYTDClick=a;return}else"all"===p&&h&&(n.navigator&&n.navigator.baseSeries[0]&&(n.navigator.baseSeries[0].xAxis.options.range=void 0),u=k,y=m);z(u)&&(u+=f._offsetMin);z(y)&&(y+=f._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=a+1);if(h)h.setExtremes(u,y,C(e,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:f});else{var A=M(n.options.xAxis)[0];var v=A.range;A.range=g;var x=A.min;A.min=q;d(n,"load",function(){A.range=v;A.min=x})}b(this,
"afterBtnClick")}};a.prototype.setSelected=function(a){this.selected=this.options.selected=a};a.prototype.init=function(a){var c=this,e=a.options.rangeSelector,f=e.buttons||c.defaultButtons.slice(),h=e.selected,n=function(){var a=c.minInput,f=c.maxInput;a&&a.blur&&b(a,"blur");f&&f.blur&&b(f,"blur")};c.chart=a;c.options=e;c.buttons=[];c.buttonOptions=f;this.eventsToUnbind=[];this.eventsToUnbind.push(d(a.container,"mousedown",n));this.eventsToUnbind.push(d(a,"resize",n));f.forEach(c.computeButtonRange);
"undefined"!==typeof h&&f[h]&&this.clickButton(h,!1);this.eventsToUnbind.push(d(a,"load",function(){a.xAxis&&a.xAxis[0]&&d(a.xAxis[0],"setExtremes",function(f){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==f.trigger&&"updatedData"!==f.trigger&&c.forcedDataGrouping&&!c.frozenStates&&this.setDataGrouping(!1,!1)})}))};a.prototype.updateButtonStates=function(){var a=this,b=this.chart,c=this.dropdown,f=b.xAxis[0],h=Math.round(f.max-f.min),e=!f.hasVisibleSeries,d=b.scroller&&b.scroller.getUnionExtremes()||
f,g=d.dataMin,k=d.dataMax;b=a.getYTDExtremes(k,g,b.time.useUTC);var m=b.min,p=b.max,q=a.selected,t=l(q),u=a.options.allButtonsEnabled,A=a.buttons;a.buttonOptions.forEach(function(b,d){var n=b._range,r=b.type,w=b.count||1,l=A[d],y=0,L=b._offsetMax-b._offsetMin;b=d===q;var P=n>k-g,O=n<f.minRange,N=!1,R=!1;n=n===h;("month"===r||"year"===r)&&h+36E5>=864E5*{month:28,year:365}[r]*w-L&&h-36E5<=864E5*{month:31,year:366}[r]*w+L?n=!0:"ytd"===r?(n=p-m+L===h,N=!b):"all"===r&&(n=f.max-f.min>=k-g,R=!b&&t&&n);r=
!u&&(P||O||R||e);w=b&&n||n&&!t&&!N||b&&a.frozenStates;r?y=3:w&&(t=!0,y=2);l.state!==y&&(l.setState(y),c&&(c.options[d+1].disabled=r,2===y&&(c.selectedIndex=d+1)),0===y&&q===d&&a.setSelected())})};a.prototype.computeButtonRange=function(a){var b=a.type,c=a.count||1,f={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(f[b])a._range=f[b]*c;else if("month"===b||"year"===b)a._range=864E5*{month:30,year:365}[b]*c;a._offsetMin=C(a.offsetMin,0);a._offsetMax=C(a.offsetMax,0);a._range+=
a._offsetMax-a._offsetMin};a.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var b=this.chart.options.rangeSelector,c=this.chart.time;return a?("text"===a.type&&b.inputDateParser||this.defaultInputDateParser)(a.value,c.useUTC,c):0};a.prototype.setInputValue=function(a,b){var c=this.options,f=this.chart.time,h="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(h){var e=h.getAttribute("data-hc-time");e=z(e)?Number(e):void 0;z(b)&&(z(e)&&
h.setAttribute("data-hc-time-previous",e),h.setAttribute("data-hc-time",b),e=b);h.value=f.dateFormat(this.inputTypeFormats[h.type]||c.inputEditDateFormat,e);a&&a.attr({text:f.dateFormat(c.inputDateFormat,e)})}};a.prototype.setInputExtremes=function(a,b,c){if(a="min"===a?this.minInput:this.maxInput){var f=this.inputTypeFormats[a.type],h=this.chart.time;f&&(b=h.dateFormat(f,b),a.min!==b&&(a.min=b),c=h.dateFormat(f,c),a.max!==c&&(a.max=c))}};a.prototype.showInput=function(a){var b="min"===a?this.minDateBox:
this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&b&&this.inputGroup){var c="text"===a.type,f=this.inputGroup,h=f.translateX;f=f.translateY;var e=this.options.inputBoxWidth;g(a,{width:c?b.width+(e?-2:20)+"px":"auto",height:c?b.height-2+"px":"auto",border:"2px solid silver"});c&&e?g(a,{left:h+b.x+"px",top:f+"px"}):g(a,{left:Math.min(Math.round(b.x+h-(a.offsetWidth-b.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:f-(a.offsetHeight-b.height)/2+"px"})}};a.prototype.hideInput=function(a){(a=
"min"===a?this.minInput:this.maxInput)&&g(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};a.prototype.defaultInputDateParser=function(a,b,c){var f=a.split("/").join("-").split(" ").join("T");-1===f.indexOf("T")&&(f+="T00:00");if(b)f+="Z";else{var h;if(h=v.isSafari)h=f,h=!(6<h.length&&(h.lastIndexOf("-")===h.length-6||h.lastIndexOf("+")===h.length-6));h&&(h=(new Date(f)).getTimezoneOffset()/60,f+=0>=h?"+"+p(-h)+":00":"-"+p(h)+":00")}f=Date.parse(f);l(f)||(a=a.split("-"),f=Date.UTC(J(a[0]),J(a[1])-
1,J(a[2])));c&&b&&l(f)&&(f+=c.getTimezoneOffset(f));return f};a.prototype.drawInput=function(a){function b(){var b=d.getInputValue(a),f=c.xAxis[0],h=c.scroller&&c.scroller.xAxis?c.scroller.xAxis:f,e=h.dataMin;h=h.dataMax;var g=d.maxInput,k=d.minInput;b!==Number(u.getAttribute("data-hc-time-previous"))&&l(b)&&(u.setAttribute("data-hc-time-previous",b),t&&g&&l(e)?b>Number(g.getAttribute("data-hc-time"))?b=void 0:b<e&&(b=e):k&&l(h)&&(b<Number(k.getAttribute("data-hc-time"))?b=void 0:b>h&&(b=h)),"undefined"!==
typeof b&&f.setExtremes(t?b:f.min,t?f.max:b,void 0,void 0,{trigger:"rangeSelectorInput"}))}var c=this.chart,f=this.div,h=this.inputGroup,d=this,n=c.renderer.style||{},m=c.renderer,p=c.options.rangeSelector,t="min"===a,P=x.lang[t?"rangeSelectorFrom":"rangeSelectorTo"]||"";P=m.label(P,0).addClass("highcharts-range-label").attr({padding:P?2:0,height:P?p.inputBoxHeight:0}).add(h);m=m.label("",0).addClass("highcharts-range-input").attr({padding:2,width:p.inputBoxWidth,height:p.inputBoxHeight,"text-align":"center"}).on("click",
function(){d.showInput(a);d[a+"Input"].focus()});c.styledMode||m.attr({stroke:p.inputBoxBorderColor,"stroke-width":1});m.add(h);var u=q("input",{name:a,className:"highcharts-range-selector"},void 0,f);u.setAttribute("type",k(p.inputDateFormat||"%b %e, %Y"));c.styledMode||(P.css(F(n,p.labelStyle)),m.css(F({color:"#333333"},n,p.inputStyle)),g(u,e({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:n.fontSize,fontFamily:n.fontFamily,
top:"-9999em"},p.inputStyle)));u.onfocus=function(){d.showInput(a)};u.onblur=function(){u===v.doc.activeElement&&b();d.hideInput(a);d.setInputValue(a);u.blur()};var A=!1;u.onchange=function(){A||(b(),d.hideInput(a),u.blur())};u.onkeypress=function(a){13===a.keyCode&&b()};u.onkeydown=function(a){A=!0;38!==a.keyCode&&40!==a.keyCode||b()};u.onkeyup=function(){A=!1};return{dateBox:m,input:u,label:P}};a.prototype.getPosition=function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?
a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}};a.prototype.getYTDExtremes=function(a,b,c){var f=this.chart.time,h=new f.Date(a),e=f.get("FullYear",h);c=c?f.Date.UTC(e,0,1):+new f.Date(e,0,1);b=Math.max(b,c);h=h.getTime();return{max:Math.min(a||h,h),min:b}};a.prototype.render=function(a,b){var c=this.chart,f=c.renderer,h=c.container,e=c.options,d=e.rangeSelector,g=C(e.chart.style&&e.chart.style.zIndex,0)+1;e=d.inputEnabled;if(!1!==d.enabled){this.rendered||
(this.group=f.g("range-selector-group").attr({zIndex:7}).add(),this.div=q("div",void 0,{position:"relative",height:0,zIndex:g}),this.buttonOptions.length&&this.renderButtons(),h.parentNode&&h.parentNode.insertBefore(this.div,h),e&&(this.inputGroup=f.g("input-group").add(this.group),f=this.drawInput("min"),this.minDateBox=f.dateBox,this.minLabel=f.label,this.minInput=f.input,f=this.drawInput("max"),this.maxDateBox=f.dateBox,this.maxLabel=f.label,this.maxInput=f.input));if(e&&(this.setInputValue("min",
a),this.setInputValue("max",b),a=c.scroller&&c.scroller.getUnionExtremes()||c.xAxis[0]||{},z(a.dataMin)&&z(a.dataMax)&&(c=c.xAxis[0].minRange||0,this.setInputExtremes("min",a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-c),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+c,a.dataMax)),this.inputGroup)){var k=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=a.getBBox().width;b&&(a.attr({x:k}),k+=b+d.inputSpacing)}})}this.alignElements();
this.rendered=!0}};a.prototype.renderButtons=function(){var a=this,c=this.buttons,e=this.options,f=x.lang,h=this.chart.renderer,g=F(e.buttonTheme),k=g&&g.states,l=g.width||28;delete g.width;delete g.states;this.buttonGroup=h.g("range-selector-buttons").add(this.group);var m=this.dropdown=q("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);d(m,"touchstart",function(){m.style.fontSize="16px"});[[v.isMS?"mouseover":
"mouseenter"],[v.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(f){var h=f[0],e=f[1];d(m,h,function(){var f=c[a.currentButtonIndex()];f&&b(f.element,e||h)})});this.zoomText=h.label(f&&f.rangeSelectorZoom||"",0).attr({padding:e.buttonTheme.padding,height:e.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(e.labelStyle),g["stroke-width"]=C(g["stroke-width"],0));q("option",{textContent:this.zoomText.textStr,disabled:!0},
void 0,m);this.buttonOptions.forEach(function(b,f){q("option",{textContent:b.title||b.text},void 0,m);c[f]=h.button(b.text,0,0,function(c){var h=b.events&&b.events.click,e;h&&(e=h.call(b,c));!1!==e&&a.clickButton(f);a.isActive=!0},g,k&&k.hover,k&&k.select,k&&k.disabled).attr({"text-align":"center",width:l}).add(a.buttonGroup);b.title&&c[f].attr("title",b.title)})};a.prototype.alignElements=function(){var a=this,b=this.buttonGroup,c=this.buttons,f=this.chart,h=this.group,e=this.inputGroup,d=this.options,
g=this.zoomText,k=f.options,m=k.exporting&&!1!==k.exporting.enabled&&k.navigation&&k.navigation.buttonOptions;k=d.buttonPosition;var l=d.inputPosition,p=d.verticalAlign,q=function(b,c){return m&&a.titleCollision(f)&&"top"===p&&"right"===c.align&&c.y-b.getBBox().height-12<(m.y||0)+(m.height||0)+f.spacing[0]?-40:0},t=f.plotLeft;if(h&&k&&l){var u=k.x-f.spacing[3];if(b){this.positionButtons();if(!this.initialButtonGroupWidth){var A=0;g&&(A+=g.getBBox().width+5);c.forEach(function(a,b){A+=a.width;b!==
c.length-1&&(A+=d.buttonSpacing)});this.initialButtonGroupWidth=A}t-=f.spacing[3];this.updateButtonStates();g=q(b,k);this.alignButtonGroup(g);h.placed=b.placed=f.hasLoaded}b=0;e&&(b=q(e,l),"left"===l.align?u=t:"right"===l.align&&(u=-Math.max(f.axisOffset[1],-b)),e.align({y:l.y,width:e.getBBox().width,align:l.align,x:l.x+u-2},!0,f.spacingBox),e.placed=f.hasLoaded);this.handleCollision(b);h.align({verticalAlign:p},!0,f.spacingBox);e=h.alignAttr.translateY;b=h.getBBox().height+20;q=0;"bottom"===p&&(q=
(q=f.legend&&f.legend.options)&&"bottom"===q.verticalAlign&&q.enabled&&!q.floating?f.legend.legendHeight+C(q.margin,10):0,b=b+q-20,q=e-b-(d.floating?0:d.y)-(f.titleOffset?f.titleOffset[2]:0)-10);if("top"===p)d.floating&&(q=0),f.titleOffset&&f.titleOffset[0]&&(q=f.titleOffset[0]),q+=f.margin[0]-f.spacing[0]||0;else if("middle"===p)if(l.y===k.y)q=e;else if(l.y||k.y)q=0>l.y||0>k.y?q-Math.min(l.y,k.y):e-b;h.translate(d.x,d.y+Math.floor(q));k=this.minInput;l=this.maxInput;e=this.dropdown;d.inputEnabled&&
k&&l&&(k.style.marginTop=h.translateY+"px",l.style.marginTop=h.translateY+"px");e&&(e.style.marginTop=h.translateY+"px")}};a.prototype.alignButtonGroup=function(a,b){var c=this.chart,f=this.buttonGroup,h=this.options.buttonPosition,e=c.plotLeft-c.spacing[3],d=h.x-c.spacing[3];"right"===h.align?d+=a-e:"center"===h.align&&(d-=e/2);f&&f.align({y:h.y,width:C(b,this.initialButtonGroupWidth),align:h.align,x:d},!0,c.spacingBox)};a.prototype.positionButtons=function(){var a=this.buttons,b=this.chart,c=this.options,
f=this.zoomText,h=b.hasLoaded?"animate":"attr",e=c.buttonPosition,d=b.plotLeft,g=d;f&&"hidden"!==f.visibility&&(f[h]({x:C(d+e.x,d)}),g+=e.x+f.getBBox().width+5);this.buttonOptions.forEach(function(b,f){if("hidden"!==a[f].visibility)a[f][h]({x:g}),g+=a[f].width+c.buttonSpacing;else a[f][h]({x:d})})};a.prototype.handleCollision=function(a){var b=this,c=this.chart,f=this.buttonGroup,h=this.inputGroup,e=this.options,d=e.buttonPosition,g=e.dropdown,k=e.inputPosition;e=function(){var a=0;b.buttons.forEach(function(b){b=
b.getBBox();b.width>a&&(a=b.width)});return a};var n=function(b){if(h&&f){var c=h.alignAttr.translateX+h.alignOptions.x-a+h.getBBox().x+2,e=h.alignOptions.width,g=f.alignAttr.translateX+f.getBBox().x;return g+b>c&&c+e>g&&d.y<k.y+h.getBBox().height}return!1},l=function(){h&&f&&h.attr({translateX:h.alignAttr.translateX+(c.axisOffset[1]>=-a?0:-a),translateY:h.alignAttr.translateY+f.getBBox().height+10})};if(f){if("always"===g){this.collapseButtons(a);n(e())&&l();return}"never"===g&&this.expandButtons()}h&&
f?k.align===d.align||n(this.initialButtonGroupWidth+20)?"responsive"===g?(this.collapseButtons(a),n(e())&&l()):l():"responsive"===g&&this.expandButtons():f&&"responsive"===g&&(this.initialButtonGroupWidth>c.plotWidth?this.collapseButtons(a):this.expandButtons())};a.prototype.collapseButtons=function(a){var b=this.buttons,c=this.buttonOptions,f=this.chart,h=this.dropdown,e=this.options,d=this.zoomText,g=f.userOptions.rangeSelector&&f.userOptions.rangeSelector.buttonTheme||{},k=function(a){return{text:a?
a+" \u25be":"\u25be",width:"auto",paddingLeft:C(e.buttonTheme.paddingLeft,g.padding,8),paddingRight:C(e.buttonTheme.paddingRight,g.padding,8)}};d&&d.hide();var n=!1;c.forEach(function(a,c){c=b[c];2!==c.state?c.hide():(c.show(),c.attr(k(a.text)),n=!0)});n||(h&&(h.selectedIndex=0),b[0].show(),b[0].attr(k(this.zoomText&&this.zoomText.textStr)));c=e.buttonPosition.align;this.positionButtons();"right"!==c&&"center"!==c||this.alignButtonGroup(a,b[this.currentButtonIndex()].getBBox().width);this.showDropdown()};
a.prototype.expandButtons=function(){var a=this.buttons,b=this.buttonOptions,c=this.options,f=this.zoomText;this.hideDropdown();f&&f.show();b.forEach(function(b,f){f=a[f];f.show();f.attr({text:b.text,width:c.buttonTheme.width||28,paddingLeft:C(c.buttonTheme.paddingLeft,"unset"),paddingRight:C(c.buttonTheme.paddingRight,"unset")});2>f.state&&f.setState(0)});this.positionButtons()};a.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};a.prototype.showDropdown=
function(){var a=this.buttonGroup,b=this.buttons,c=this.chart,f=this.dropdown;if(a&&f){var h=a.translateX;a=a.translateY;b=b[this.currentButtonIndex()].getBBox();g(f,{left:c.plotLeft+h+"px",top:a+.5+"px",width:b.width+"px",height:b.height+"px"});this.hasVisibleDropdown=!0}};a.prototype.hideDropdown=function(){var a=this.dropdown;a&&(g(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};a.prototype.getHeight=function(){var a=this.options,b=this.group,c=a.y,f=a.buttonPosition.y,
h=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=b?b.getBBox(!0).height+13+c:0;b=Math.min(h,f);if(0>h&&0>f||0<h&&0<f)a+=Math.abs(b);return a};a.prototype.titleCollision=function(a){return!(a.options.title.text||a.options.subtitle.text)};a.prototype.update=function(a){var b=this.chart;F(!0,b.options.rangeSelector,a);this.destroy();this.init(b);this.render()};a.prototype.destroy=function(){var b=this,c=b.minInput,e=b.maxInput;b.eventsToUnbind&&(b.eventsToUnbind.forEach(function(a){return a()}),
b.eventsToUnbind=void 0);D(b.buttons);c&&(c.onfocus=c.onblur=c.onchange=null);e&&(e.onfocus=e.onblur=e.onchange=null);G(b,function(c,h){c&&"chart"!==h&&(c instanceof B?c.destroy():c instanceof window.HTMLElement&&H(c));c!==a.prototype[h]&&(b[h]=null)},this)};return a}();E.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},
{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];E.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};c.prototype.minFromRange=function(){var a=this.range,b=a.type,c=this.max,e=this.chart.time,f=function(a,c){var f="year"===b?"FullYear":"Month",h=new e.Date(a),d=e.get(f,h);e.set(f,h,d+c);d===e.get(f,h)&&e.set("Date",h,0);return h.getTime()-a};if(l(a)){var h=c-a;var d=a}else h=c+f(c,-a.count),this.chart&&(this.chart.fixedRange=
c-h);var g=C(this.dataMin,Number.MIN_VALUE);l(h)||(h=g);h<=g&&(h=g,"undefined"===typeof d&&(d=f(h,a.count)),this.newMax=Math.min(h+d,this.dataMax));l(c)||(h=void 0);return h};if(!v.RangeSelector){var K=[],I=function(b){function c(){g&&(e=b.xAxis[0].getExtremes(),f=b.legend,k=g&&g.options.verticalAlign,l(e.min)&&g.render(e.min,e.max),f.display&&"top"===k&&k===f.options.verticalAlign&&(h=F(b.spacingBox),h.y="vertical"===f.options.layout?b.plotTop:h.y+g.getHeight(),f.group.placed=!1,f.align(h)))}var e,
g=b.rangeSelector,f,h,k;g&&(a(K,function(a){return a[0]===b})||K.push([b,[d(b.xAxis[0],"afterSetExtremes",function(a){g&&g.render(a.min,a.max)}),d(b,"redraw",c)]]),c())};d(t,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new E(this))});d(t,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(l(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),
this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))});d(t,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var c=this.extraBottomMargin,e=this.extraTopMargin;b&&b.enabled&&!z(a)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=a=new E(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(I(this),b=b&&b.verticalAlign||a.options&&
a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==c||this.extraTopMargin!==e)&&(this.isDirtyBox=!0)});d(t,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))});d(t,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=
a),this.extraBottomMargin&&(this.marginBottom+=a))});t.prototype.callbacks.push(I);d(t,"destroy",function(){for(var a=0;a<K.length;a++){var b=K[a];if(b[0]===this){b[1].forEach(function(a){return a()});K.splice(a,1);break}}});v.RangeSelector=E}return E});J(c,"Core/Axis/NavigatorAxis.js",[c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,t){var v=c.isTouchDevice,u=t.addEvent,B=t.correctFloat,m=t.defined,k=t.isNumber,x=t.pick,d=function(){function c(c){this.axis=c}c.prototype.destroy=function(){this.axis=
void 0};c.prototype.toFixedRange=function(c,d,q,t){var e=this.axis,a=e.chart;a=a&&a.fixedRange;var b=(e.pointRange||0)/2;c=x(q,e.translate(c,!0,!e.horiz));d=x(t,e.translate(d,!0,!e.horiz));e=a&&(d-c)/a;m(q)||(c=B(c+b));m(t)||(d=B(d-b));.7<e&&1.3>e&&(t?c=d-a:d=c+a);k(c)&&k(d)||(c=d=void 0);return{min:c,max:d}};return c}();return function(){function c(){}c.compose=function(c){c.keepProps.push("navigatorAxis");u(c,"init",function(){this.navigatorAxis||(this.navigatorAxis=new d(this))});u(c,"zoom",function(c){var d=
this.chart.options,g=d.navigator,e=this.navigatorAxis,a=d.chart.pinchType,b=d.rangeSelector;d=d.chart.zoomType;this.isXAxis&&(g&&g.enabled||b&&b.enabled)&&("y"===d?c.zoomed=!1:(!v&&"xy"===d||v&&"xy"===a)&&this.options.range&&(g=e.previousZoom,m(c.newMin)?e.previousZoom=[this.min,this.max]:g&&(c.newMin=g[0],c.newMax=g[1],e.previousZoom=void 0)));"undefined"!==typeof c.zoomed&&c.preventDefault()})};c.AdditionsClass=d;return c}()});J(c,"Core/Navigator.js",[c["Core/Axis/Axis.js"],c["Core/Chart/Chart.js"],
c["Core/Color/Color.js"],c["Core/Globals.js"],c["Core/Axis/NavigatorAxis.js"],c["Core/DefaultOptions.js"],c["Core/Renderer/RendererRegistry.js"],c["Core/Scrollbar.js"],c["Core/Series/Series.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,t,v,u,B,m,k,x,d,q,g){v=v.parse;var z=u.hasTouch,D=u.isTouchDevice,H=m.defaultOptions,e=g.addEvent,a=g.clamp,b=g.correctFloat,l=g.defined,F=g.destroyObjectProperties,G=g.erase,p=g.extend,C=g.find,J=g.isArray,M=g.isNumber,E=g.merge,K=g.pick,
I=g.removeEvent,A=g.splat,n=function(a){for(var b=[],c=1;c<arguments.length;c++)b[c-1]=arguments[c];b=[].filter.call(b,M);if(b.length)return Math[a].apply(0,b)};m="undefined"===typeof q.seriesTypes.areaspline?"line":"areaspline";p(H,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:v("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,
series:{type:m,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,
marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});k.getRendererType().prototype.symbols["navigator-handle"]=
function(a,b,c,e,d){a=(d&&d.width||0)/2;b=Math.round(a/3)+.5;d=d&&d.height||0;return[["M",-a-1,.5],["L",a,.5],["L",a,d+.5],["L",-a-1,d+.5],["L",-a-1,.5],["M",-b,4],["L",-b,d-3],["M",b-1,4],["L",b-1,d-3]]};var y=function(){function d(a){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=
this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(a)}d.prototype.drawHandle=function(a,b,c,e){var f=this.navigatorOptions.handles.height;this.handles[b][e](c?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(a,10)+.5-f)}:{translateX:Math.round(this.left+parseInt(a,10)),translateY:Math.round(this.top+this.height/2-f/2-1)})};d.prototype.drawOutline=function(a,b,c,e){var f=this.navigatorOptions.maskInside,d=this.outline.strokeWidth(),h=d/2,g=d%
2/2;d=this.outlineHeight;var k=this.scrollbarHeight||0,l=this.size,m=this.left-k,n=this.top;c?(m-=h,c=n+b+g,b=n+a+g,g=[["M",m+d,n-k-g],["L",m+d,c],["L",m,c],["L",m,b],["L",m+d,b],["L",m+d,n+l+k]],f&&g.push(["M",m+d,c-h],["L",m+d,b+h])):(a+=m+k-g,b+=m+k-g,n+=h,g=[["M",m,n],["L",a,n],["L",a,n+d],["L",b,n+d],["L",b,n],["L",m+l+2*k,n]],f&&g.push(["M",a-h,n],["L",b+h,n]));this.outline[e]({d:g})};d.prototype.drawMasks=function(a,b,c,d){var f=this.left,e=this.top,h=this.height;if(c){var g=[f,f,f];var k=
[e,e+a,e+b];var l=[h,h,h];var m=[a,b-a,this.size-b]}else g=[f,f+a,f+b],k=[e,e,e],l=[a,b-a,this.size-b],m=[h,h,h];this.shades.forEach(function(a,b){a[d]({x:g[b],y:k[b],width:l[b],height:m[b]})})};d.prototype.renderElements=function(){var a=this,b=a.navigatorOptions,c=b.maskInside,d=a.chart,e=d.renderer,g,k={cursor:d.inverted?"ns-resize":"ew-resize"};a.navigatorGroup=g=e.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!c,c,!c].forEach(function(c,f){var h=e.rect().addClass("highcharts-navigator-mask"+
(1===f?"-inside":"-outside")).add(g);d.styledMode||(h.attr({fill:c?b.maskFill:"rgba(0,0,0,0)"}),1===f&&h.css(k));a.shades[f]=h});a.outline=e.path().addClass("highcharts-navigator-outline").add(g);d.styledMode||a.outline.attr({"stroke-width":b.outlineWidth,stroke:b.outlineColor});b.handles.enabled&&[0,1].forEach(function(c){b.handles.inverted=d.inverted;a.handles[c]=e.symbol(b.handles.symbols[c],-b.handles.width/2-1,0,b.handles.width,b.handles.height,b.handles);a.handles[c].attr({zIndex:7-c}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+
["left","right"][c]).add(g);if(!d.styledMode){var f=b.handles;a.handles[c].attr({fill:f.backgroundColor,stroke:f.borderColor,"stroke-width":f.lineWidth}).css(k)}})};d.prototype.update=function(a){(this.series||[]).forEach(function(a){a.baseSeries&&delete a.baseSeries.navigatorSeries});this.destroy();E(!0,this.chart.options.navigator,this.options,a);this.init(this.chart)};d.prototype.render=function(c,d,e,g){var f=this.chart,h=this.scrollbarHeight,k,m=this.xAxis,n=m.pointRange||0;var p=m.navigatorAxis.fake?
f.xAxis[0]:m;var r=this.navigatorEnabled,w,q=this.rendered;var t=f.inverted;var u=f.xAxis[0].minRange,v=f.xAxis[0].options.maxRange;if(!this.hasDragged||l(e)){c=b(c-n/2);d=b(d+n/2);if(!M(c)||!M(d))if(q)e=0,g=K(m.width,p.width);else return;this.left=K(m.left,f.plotLeft+h+(t?f.plotWidth:0));this.size=w=k=K(m.len,(t?f.plotHeight:f.plotWidth)-2*h);f=t?h:k+2*h;e=K(e,m.toPixels(c,!0));g=K(g,m.toPixels(d,!0));M(e)&&Infinity!==Math.abs(e)||(e=0,g=f);c=m.toValue(e,!0);d=m.toValue(g,!0);var x=Math.abs(b(d-
c));x<u?this.grabbedLeft?e=m.toPixels(d-u-n,!0):this.grabbedRight&&(g=m.toPixels(c+u+n,!0)):l(v)&&b(x-n)>v&&(this.grabbedLeft?e=m.toPixels(d-v-n,!0):this.grabbedRight&&(g=m.toPixels(c+v+n,!0)));this.zoomedMax=a(Math.max(e,g),0,w);this.zoomedMin=a(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(e,g),0,w);this.range=this.zoomedMax-this.zoomedMin;w=Math.round(this.zoomedMax);e=Math.round(this.zoomedMin);r&&(this.navigatorGroup.attr({visibility:"visible"}),q=q&&!this.hasDragged?"animate":"attr",
this.drawMasks(e,w,t,q),this.drawOutline(e,w,t,q),this.navigatorOptions.handles.enabled&&(this.drawHandle(e,0,t,q),this.drawHandle(w,1,t,q)));this.scrollbar&&(t?(t=this.top-h,p=this.left-h+(r||!p.opposite?0:(p.titleOffset||0)+p.axisTitleMargin),h=k+2*h):(t=this.top+(r?this.height:-h),p=this.left-h),this.scrollbar.position(p,t,f,h),this.scrollbar.setRange(this.zoomedMin/(k||1),this.zoomedMax/(k||1)));this.rendered=!0}};d.prototype.addMouseEvents=function(){var a=this,b=a.chart,c=b.container,d=[],g,
k;a.mouseMoveHandler=g=function(b){a.onMouseMove(b)};a.mouseUpHandler=k=function(b){a.onMouseUp(b)};d=a.getPartsEvents("mousedown");d.push(e(b.renderTo,"mousemove",g),e(c.ownerDocument,"mouseup",k));z&&(d.push(e(b.renderTo,"touchmove",g),e(c.ownerDocument,"touchend",k)),d.concat(a.getPartsEvents("touchstart")));a.eventsToUnbind=d;a.series&&a.series[0]&&d.push(e(a.series[0].xAxis,"foundExtremes",function(){b.navigator.modifyNavigatorAxisExtremes()}))};d.prototype.getPartsEvents=function(a){var b=this,
c=[];["shades","handles"].forEach(function(f){b[f].forEach(function(d,h){c.push(e(d.element,a,function(a){b[f+"Mousedown"](a,h)}))})});return c};d.prototype.shadesMousedown=function(a,b){a=this.chart.pointer.normalize(a);var c=this.chart,f=this.xAxis,d=this.zoomedMin,e=this.left,h=this.size,g=this.range,k=a.chartX;c.inverted&&(k=a.chartY,e=this.top);if(1===b)this.grabbedCenter=k,this.fixedWidth=g,this.dragOffset=k-d;else{a=k-e-g/2;if(0===b)a=Math.max(0,a);else if(2===b&&a+g>=h)if(a=h-g,this.reversedExtremes){a-=
g;var m=this.getUnionExtremes().dataMin}else var n=this.getUnionExtremes().dataMax;a!==d&&(this.fixedWidth=g,b=f.navigatorAxis.toFixedRange(a,a+g,m,n),l(b.min)&&c.xAxis[0].setExtremes(Math.min(b.min,b.max),Math.max(b.min,b.max),!0,null,{trigger:"navigator"}))}};d.prototype.handlesMousedown=function(a,b){this.chart.pointer.normalize(a);a=this.chart;var c=a.xAxis[0],f=this.reversedExtremes;0===b?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=f?c.min:c.max):(this.grabbedRight=
!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=f?c.max:c.min);a.fixedRange=null};d.prototype.onMouseMove=function(a){var b=this,c=b.chart,f=b.left,d=b.navigatorSize,e=b.range,g=b.dragOffset,k=c.inverted;a.touches&&0===a.touches[0].pageX||(a=c.pointer.normalize(a),c=a.chartX,k&&(f=b.top,c=a.chartY),b.grabbedLeft?(b.hasDragged=!0,b.render(0,0,c-f,b.otherHandlePos)):b.grabbedRight?(b.hasDragged=!0,b.render(0,0,b.otherHandlePos,c-f)):b.grabbedCenter&&(b.hasDragged=!0,c<g?c=g:c>d+g-e&&(c=d+g-
e),b.render(0,0,c-g,c-g+e)),b.hasDragged&&b.scrollbar&&K(b.scrollbar.options.liveRedraw,u.svg&&!D&&!this.chart.isBoosting)&&(a.DOMType=a.type,setTimeout(function(){b.onMouseUp(a)},0)))};d.prototype.onMouseUp=function(a){var b=this.chart,c=this.xAxis,f=this.scrollbar,d=a.DOMEvent||a,e=b.inverted,g=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!f||!f.hasDragged)||"scrollbar"===a.trigger){f=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var k=this.fixedExtreme;
else if(this.zoomedMax===this.otherHandlePos)var m=this.fixedExtreme;this.zoomedMax===this.size&&(m=this.reversedExtremes?f.dataMin:f.dataMax);0===this.zoomedMin&&(k=this.reversedExtremes?f.dataMax:f.dataMin);c=c.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,k,m);l(c.min)&&b.xAxis[0].setExtremes(Math.min(c.min,c.max),Math.max(c.min,c.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:d})}"mousemove"!==a.DOMType&&"touchmove"!==a.DOMType&&(this.grabbedLeft=
this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&M(this.zoomedMin)&&M(this.zoomedMax)&&(b=Math.round(this.zoomedMin),a=Math.round(this.zoomedMax),this.shades&&this.drawMasks(b,a,e,g),this.outline&&this.drawOutline(b,a,e,g),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(b,0,e,g),this.drawHandle(a,1,e,g)))};d.prototype.removeEvents=function(){this.eventsToUnbind&&
(this.eventsToUnbind.forEach(function(a){a()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};d.prototype.removeBaseSeriesEvents=function(){var a=this.baseSeries||[];this.navigatorEnabled&&a[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&a.forEach(function(a){I(a,"updatedData",this.updatedDataHandler)},this),a[0].xAxis&&I(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};d.prototype.init=function(a){var b=a.options,f=b.navigator,d=f.enabled,g=b.scrollbar,k=g.enabled;b=d?f.height:
0;var m=k?g.height:0;this.handles=[];this.shades=[];this.chart=a;this.setBaseSeries();this.height=b;this.scrollbarHeight=m;this.scrollbarEnabled=k;this.navigatorEnabled=d;this.navigatorOptions=f;this.scrollbarOptions=g;this.outlineHeight=b+m;this.opposite=K(f.opposite,!(d||!a.inverted));var l=this;d=l.baseSeries;g=a.xAxis.length;k=a.yAxis.length;var p=d&&d[0]&&d[0].xAxis||a.xAxis[0]||{options:{}};a.isDirtyBox=!0;l.navigatorEnabled?(l.xAxis=new c(a,E({breaks:p.options.breaks,ordinal:p.options.ordinal},
f.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:g,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},a.inverted?{offsets:[m,0,-m,0],width:b}:{offsets:[0,-m,0,m],height:b})),l.yAxis=new c(a,E(f.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:k,isInternal:!0,reversed:K(f.yAxis&&f.yAxis.reversed,a.yAxis[0]&&a.yAxis[0].reversed,!1),zoomEnabled:!1},a.inverted?{width:b}:{height:b})),d||f.series.data?
l.updateNavigatorSeries(!1):0===a.series.length&&(l.unbindRedraw=e(a,"beforeRedraw",function(){0<a.series.length&&!l.series&&(l.setBaseSeries(),l.unbindRedraw())})),l.reversedExtremes=a.inverted&&!l.xAxis.reversed||!a.inverted&&l.xAxis.reversed,l.renderElements(),l.addMouseEvents()):(l.xAxis={chart:a,navigatorAxis:{fake:!0},translate:function(b,c){var f=a.xAxis[0],d=f.getExtremes(),e=f.len-2*m,h=n("min",f.options.min,d.dataMin);f=n("max",f.options.max,d.dataMax)-h;return c?b*f/e+h:e*(b-h)/f},toPixels:function(a){return this.translate(a)},
toValue:function(a){return this.translate(a,!0)}},l.xAxis.navigatorAxis.axis=l.xAxis,l.xAxis.navigatorAxis.toFixedRange=B.AdditionsClass.prototype.toFixedRange.bind(l.xAxis.navigatorAxis));a.options.scrollbar.enabled&&(a.scrollbar=l.scrollbar=new x(a.renderer,E(a.options.scrollbar,{margin:l.navigatorEnabled?0:10,vertical:a.inverted}),a),e(l.scrollbar,"changed",function(a){var b=l.size,c=b*this.to;b*=this.from;l.hasDragged=l.scrollbar.hasDragged;l.render(0,0,b,c);this.shouldUpdateExtremes(a.DOMType)&&
setTimeout(function(){l.onMouseUp(a)})}));l.addBaseSeriesEvents();l.addChartEvents()};d.prototype.getUnionExtremes=function(a){var b=this.chart.xAxis[0],c=this.xAxis,f=c.options,d=b.options,e;a&&null===b.dataMin||(e={dataMin:K(f&&f.min,n("min",d.min,b.dataMin,c.dataMin,c.min)),dataMax:K(f&&f.max,n("max",d.max,b.dataMax,c.dataMax,c.max))});return e};d.prototype.setBaseSeries=function(a,b){var c=this.chart,f=this.baseSeries=[];a=a||c.options&&c.options.navigator.baseSeries||(c.series.length?C(c.series,
function(a){return!a.options.isInternal}).index:0);(c.series||[]).forEach(function(b,c){b.options.isInternal||!b.options.showInNavigator&&(c!==a&&b.options.id!==a||!1===b.options.showInNavigator)||f.push(b)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,b)};d.prototype.updateNavigatorSeries=function(a,b){var c=this,f=c.chart,d=c.baseSeries,e,h,g=c.navigatorOptions.series,k,l={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",
yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},m=c.series=(c.series||[]).filter(function(a){var b=a.baseSeries;return 0>d.indexOf(b)?(b&&(I(b,"updatedData",c.updatedDataHandler),delete b.navigatorSeries),a.chart&&a.destroy(),!1):!0});d&&d.length&&d.forEach(function(a){var n=a.navigatorSeries,r=p({color:a.color,visible:a.visible},J(g)?H.navigator.series:g);n&&!1===c.navigatorOptions.adaptToUpdatedData||(l.name="Navigator "+d.length,e=a.options||
{},k=e.navigatorOptions||{},r.dataLabels=A(r.dataLabels),h=E(e,l,r,k),h.pointRange=K(r.pointRange,k.pointRange,H.plotOptions[h.type||"line"].pointRange),r=k.data||r.data,c.hasNavigatorData=c.hasNavigatorData||!!r,h.data=r||e.data&&e.data.slice(0),n&&n.options?n.update(h,b):(a.navigatorSeries=f.initSeries(h),a.navigatorSeries.baseSeries=a,m.push(a.navigatorSeries)))});if(g.data&&(!d||!d.length)||J(g))c.hasNavigatorData=!1,g=A(g),g.forEach(function(a,b){l.name="Navigator "+(m.length+1);h=E(H.navigator.series,
{color:f.series[b]&&!f.series[b].options.isInternal&&f.series[b].color||f.options.colors[b]||f.options.colors[0]},l,a);h.data=a.data;h.data&&(c.hasNavigatorData=!0,m.push(f.initSeries(h)))});a&&this.addBaseSeriesEvents()};d.prototype.addBaseSeriesEvents=function(){var a=this,b=a.baseSeries||[];b[0]&&b[0].xAxis&&b[0].eventsToUnbind.push(e(b[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));b.forEach(function(b){b.eventsToUnbind.push(e(b,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,
!1)}));b.eventsToUnbind.push(e(b,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)}));!1!==this.navigatorOptions.adaptToUpdatedData&&b.xAxis&&b.eventsToUnbind.push(e(b,"updatedData",this.updatedDataHandler));b.eventsToUnbind.push(e(b,"remove",function(){this.navigatorSeries&&(G(a.series,this.navigatorSeries),l(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)};d.prototype.getBaseSeriesMin=function(a){return this.baseSeries.reduce(function(a,
b){return Math.min(a,b.xData&&b.xData.length?b.xData[0]:a)},a)};d.prototype.modifyNavigatorAxisExtremes=function(){var a=this.xAxis,b;"undefined"!==typeof a.getExtremes&&(!(b=this.getUnionExtremes(!0))||b.dataMin===a.min&&b.dataMax===a.max||(a.min=b.dataMin,a.max=b.dataMax))};d.prototype.modifyBaseAxisExtremes=function(){var a=this.chart.navigator,b=this.getExtremes(),c=b.dataMin,d=b.dataMax;b=b.max-b.min;var e=a.stickToMin,g=a.stickToMax,k=K(this.options.overscroll,0),l=a.series&&a.series[0],m=!!this.setExtremes;
if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(e){var n=c;var p=n+b}g&&(p=d+k,e||(n=Math.max(c,p-b,a.getBaseSeriesMin(l&&l.xData?l.xData[0]:-Number.MAX_VALUE))));m&&(e||g)&&M(n)&&(this.min=this.userMin=n,this.max=this.userMax=p)}a.stickToMin=a.stickToMax=null};d.prototype.updatedDataHandler=function(){var a=this.chart.navigator,b=this.navigatorSeries;a.stickToMax=a.reversedExtremes?0===Math.round(a.zoomedMin):Math.round(a.zoomedMax)>=Math.round(a.size);a.stickToMin=a.shouldStickToMin(this,
a);b&&!a.hasNavigatorData&&(b.options.pointStart=this.xData[0],b.setData(this.options.data,!1,null,!1))};d.prototype.shouldStickToMin=function(a,b){b=b.getBaseSeriesMin(a.xData[0]);var c=a.xAxis;a=c.max;var d=c.min;c=c.options.range;return M(a)&&M(d)?c&&0<a-b?a-b<c:d<=b:!1};d.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(e(this.chart,"redraw",function(){var a=this.navigator,b=a&&(a.baseSeries&&a.baseSeries[0]&&a.baseSeries[0].xAxis||this.xAxis[0]);
b&&a.render(b.min,b.max)}),e(this.chart,"getMargins",function(){var a=this.navigator,b=a.opposite?"plotTop":"marginBottom";this.inverted&&(b=a.opposite?"marginRight":"plotLeft");this[b]=(this[b]||0)+(a.navigatorEnabled||!this.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))};d.prototype.destroy=function(){this.removeEvents();this.xAxis&&(G(this.chart.xAxis,this.xAxis),G(this.chart.axes,this.xAxis));this.yAxis&&(G(this.chart.yAxis,this.yAxis),G(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(a){a.destroy&&
a.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(a){this[a]&&this[a].destroy&&this[a].destroy();this[a]=null},this);[this.handles].forEach(function(a){F(a)},this)};return d}();u.Navigator||(u.Navigator=y,B.compose(c),e(t,"beforeShowResetZoom",function(){var a=this.options,b=a.navigator,c=a.rangeSelector;if((b&&b.enabled||c&&c.enabled)&&(!D&&"x"===a.chart.zoomType||D&&"x"===a.chart.pinchType))return!1}),
e(t,"beforeRender",function(){var a=this.options;if(a.navigator.enabled||a.scrollbar.enabled)this.scroller=this.navigator=new y(this)}),e(t,"afterSetChartSize",function(){var a=this.legend,b=this.navigator;if(b){var c=a&&a.options;var d=b.xAxis;var e=b.yAxis;var g=b.scrollbarHeight;this.inverted?(b.left=b.opposite?this.chartWidth-g-b.height:this.spacing[3]+g,b.top=this.plotTop+g):(b.left=K(d.left,this.plotLeft+g),b.top=b.navigatorOptions.top||this.chartHeight-b.height-g-this.spacing[2]-(this.rangeSelector&&
this.extraBottomMargin?this.rangeSelector.getHeight():0)-(c&&"bottom"===c.verticalAlign&&"proximate"!==c.layout&&c.enabled&&!c.floating?a.legendHeight+K(c.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));d&&e&&(this.inverted?d.options.left=e.options.left=b.left:d.options.top=e.options.top=b.top,d.setAxisSize(),e.setAxisSize())}}),e(t,"update",function(a){var b=a.options.navigator||{},c=a.options.scrollbar||{};this.navigator||this.scroller||!b.enabled&&!c.enabled||(E(!0,this.options.navigator,
b),E(!0,this.options.scrollbar,c),delete a.options.navigator,delete a.options.scrollbar)}),e(t,"afterUpdate",function(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new y(this),K(a.redraw,!0)&&this.redraw(a.animation))}),e(t,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),e(d,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,
!1)}),t.prototype.callbacks.push(function(a){var b=a.navigator;b&&a.xAxis[0]&&(a=a.xAxis[0].getExtremes(),b.render(a.min,a.max))}));u.Navigator=y;return u.Navigator});J(c,"masters/modules/gantt.src.js",[c["Core/Globals.js"],c["Core/Chart/GanttChart.js"],c["Core/Scrollbar.js"]],function(c,t,v){c.Scrollbar=v;c.GanttChart=t;c.ganttChart=t.ganttChart;v.compose(c.Axis)})});
//# sourceMappingURL=gantt.js.map