<?php

include("../../lib/inc/config.php");

if(session_id() == '') {
    session_start();
}

function result_to_array($result) {
    $rows = [];
    while($row = mysqli_fetch_assoc($result)) {
        $rows[] = $row;
    }
    return $rows;
}

function result_to_hashmap($result, $key, $value) {
    $rows = result_to_array($result);
    $hashmap = [];
    foreach($rows as $row) {
        $hashmap[$row[$key]] = $row[$value];
    }
    return $hashmap;
}

$module_map = result_to_hashmap(mysqli_query($conn, "SELECT * FROM hsi_module"), "module_id", "module_name");
$module_sublist_map = result_to_hashmap(mysqli_query($conn, "SELECT * FROM hsi_module_sublist"), "sublist_id", "sublist_name");
$module_item_weight_map = result_to_hashmap(mysqli_query($conn, "SELECT * FROM hsi_module_item"), "item_id", "item_weight");

$module_result = result_to_array(mysqli_query($conn, "SELECT * FROM hsi_module_result WHERE result_id = " . $_GET['id']));
$json = json_decode(utf8_decode($module_result[0]["json_result"]), true);

$html_result = "";
foreach($json["modules"] as $module) {
    $html_result =  $html_result .
                    "<div style='font-size: 1.75em; font-weight: bold; justify-content: center; display: flex; flex-wrap: wrap; width: 100%; margin-top: 15px;'>" .
                        $module_map[$module['module_id']] .
                    "</div>";


    foreach($module["sublists"] as $sublist) {

        $blank = $rendah = $sedang = $tinggi = $bobot_blank = $bobot_rendah = $bobot_sedang = $bobot_tinggi = $total_butir = $total_bobot = 0;
        foreach($sublist["items"] as $item) {
            if($item["answer"] == "Blank") { $blank++; $bobot_blank += $module_item_weight_map[$item['item_id']]; }
            if($item["answer"] == "Rendah") { $rendah++; $bobot_rendah += $module_item_weight_map[$item['item_id']]; }
            if($item["answer"] == "Sedang") { $sedang++; $bobot_sedang += $module_item_weight_map[$item['item_id']]; }
            if($item["answer"] == "Tinggi") { $tinggi++; $bobot_tinggi += $module_item_weight_map[$item['item_id']]; }
        }

        $total_butir = $blank + $rendah + $sedang + $tinggi;
        $total_bobot = $bobot_blank + $bobot_rendah + $bobot_sedang + $bobot_tinggi;

        $html_result =  $html_result .
                        "<div style='display: flex; flex-wrap: wrap; width: 100%; border: 2px solid black; margin-top: 15px; padding: 15px; background-color: whitesmoke'>" .
                            "<div style='display: flex; flex-wrap: wrap; width: 100%; font-size: 1.4em;'>" . $module_sublist_map[$sublist['sublist_id']] . "</div>" .
                            "<div style='display: flex; flex-wrap: wrap; width: 100%; margin-top: 10px; padding: 5px 0px; border-bottom: 1px solid black;'>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 40%;'>" . "Level Keamanan" . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . "Total Butir" . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . "Total Bobot" . "</div>" .
                            "</div>" .
                            "<div style='display: flex; flex-wrap: wrap; width: 100%; padding: 5px 0px; border-bottom: 1px solid black; font-weight: bold'>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 40%;'>" . "Blank" . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . $blank . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . $bobot_blank . "%" . "</div>" .
                            "</div>" .
                            "<div style='display: flex; flex-wrap: wrap; width: 100%; padding: 5px 0px; border-bottom: 1px solid black; font-weight: bold'>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 40%;'>" . "Rendah" . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . $rendah . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . $bobot_rendah . "%" . "</div>" .
                            "</div>" .
                            "<div style='display: flex; flex-wrap: wrap; width: 100%; padding: 5px 0px; border-bottom: 1px solid black; font-weight: bold'>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 40%;'>" . "Sedang" . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . $sedang . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . $bobot_sedang . "%" . "</div>" .
                            "</div>" .
                            "<div style='display: flex; flex-wrap: wrap; width: 100%; padding: 5px 0px; border-bottom: 1px solid black; font-weight: bold'>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 40%;'>" . "Tinggi" . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . $tinggi . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . $bobot_tinggi . "%" . "</div>" .
                            "</div>" .
                            "<div style='display: flex; flex-wrap: wrap; width: 100%; padding: 5px 0px; border-bottom: 1px solid black; font-weight: bold'>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 40%;'>" . "Total" . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . $total_butir . "</div>" .
                                "<div style='display: flex; flex-wrap: wrap; width: 30%;'>" . $total_bobot . "%" . "</div>" .
                            "</div>" .
                        "</div>";
    }
}

echo json_encode($html_result);