<?php

include("../../lib/inc/config.php");

if(session_id() == '') {
    session_start();
}

function result_to_array($result) {
    $rows = [];
    while($row = mysqli_fetch_assoc($result)) {
        $rows[] = $row;
    }
    return $rows;
}

function result_to_hashmap($result, $key, $value) {
    $rows = result_to_array($result);
    $hashmap = [];
    foreach($rows as $row) {
        $hashmap[$row[$key]] = $row[$value];
    }
    return $hashmap;
}

$module_map = result_to_hashmap(mysqli_query($conn, "SELECT * FROM hsi_module"), "module_id", "module_name");

$module_result = result_to_array(mysqli_query($conn, "SELECT * FROM hsi_module_result WHERE result_id = " . $_GET['id']));
$json = json_decode(utf8_decode($module_result[0]["json_result"]), true);

$html_result = "";
foreach($json["modules"] as $module) {

    $blank = $rendah = $sedang = $tinggi = 0;
    foreach($module["sublists"] as $sublist) {
        foreach($sublist["items"] as $item) {
            if($item["answer"] == "Blank") $blank++;
            if($item["answer"] == "Rendah") $rendah++;
            if($item["answer"] == "Sedang") $sedang++;
            if($item["answer"] == "Tinggi") $tinggi++;
        }
    }

    $html_result =  $html_result .
        "<div style='display: flex; flex-wrap: wrap; width: 100%; border: 2px solid black; margin-top: 15px; margin-bottom: 10px; padding: 15px; background-color: #01c0c8'>" .
            "<div style='font-size: 1.75em; font-weight: bold; justify-content: center; display: flex; flex-wrap: wrap; width: 100%; color: black'>" .
                $module_map[$module['module_id']] .
            "</div>" .
            "<div style='display: flex; flex-wrap: wrap; width: 100%; justify-content: space-around; margin-top: 10px;'>" .
                "<div style='display: flex; flex-wrap: wrap; width: 300px; border: 1px solid black; margin-top: 12px; padding: 15px 20px; border-radius: 20px; background-color: whitesmoke'>" .
                    "<div style='font-size: 2em; width: 100%; color: black'>" . $blank . "</div>" .
                    "<div style='font-size: 1em; width: 100%; color: black'>" . "Fasilitas Tidak Ada" . "</div>" .
                "</div>" .
                "<div style='display: flex; flex-wrap: wrap; width: 300px; border: 1px solid black; margin-top: 12px; padding: 15px 20px; border-radius: 20px; background-color: whitesmoke'>" .
                    "<div style='font-size: 2em; width: 100%; color: black'>" . $rendah . "</div>" .
                    "<div style='font-size: 1em; width: 100%; color: black'>" . "Tidak Mungkin Berfungsi" . "</div>" .
                "</div>" .
                "<div style='display: flex; flex-wrap: wrap; width: 300px; border: 1px solid black; margin-top: 12px; padding: 15px 20px; border-radius: 20px; background-color: whitesmoke'>" .
                    "<div style='font-size: 2em; width: 100%; color: black'>" . $sedang . "</div>" .
                    "<div style='font-size: 1em; width: 100%; color: black'>" . "Mungkin Berfungsi" . "</div>" .
                "</div>" .
                "<div style='display: flex; flex-wrap: wrap; width: 300px; border: 1px solid black; margin-top: 12px; padding: 15px 20px; border-radius: 20px; background-color: whitesmoke'>" .
                    "<div style='font-size: 2em; width: 100%; color: black'>" . $tinggi . "</div>" .
                    "<div style='font-size: 1em; width: 100%; color: black'>" . "Sangat Mungkin Berfungsi" . "</div>" .
                "</div>" .
            "</div>" .
        "</div>";

}

echo json_encode($html_result);